/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.calendarviews;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.joda.time.DateMidnight;
import org.joda.time.ReadableInstant;
import org.wicketstuff.calendarviews.BaseCalendarView;
import org.wicketstuff.calendarviews.logic.DateMidnightIterator;
import org.wicketstuff.calendarviews.model.IEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface IRenderStrategy {
    public static final IRenderStrategy ONLY_ONCE_PER_EVENT = new IRenderStrategy(){

        @Override
        public void mapEvent(Map<DateMidnight, List<IEvent>> map, IEvent event, BaseCalendarView calendar) {
            RenderStrategyUtility.addEventToDate(map, new DateMidnight((Object)event.getStartTime()), event);
        }
    };
    public static final IRenderStrategy EVERY_DAY_OF_EVENT = new IRenderStrategy(){

        @Override
        public void mapEvent(Map<DateMidnight, List<IEvent>> map, IEvent event, BaseCalendarView calendar) {
            DateMidnight start;
            DateMidnight end = start = new DateMidnight((Object)event.getStartTime());
            if (event.getEndTime() != null && !event.getEndTime().equals(event.getStartTime())) {
                end = new DateMidnight((Object)event.getEndTime());
            }
            if (end.isAfter((ReadableInstant)start)) {
                DateMidnightIterator it = new DateMidnightIterator(start.toDateTime(), end.toDateTime());
                while (it.hasNext()) {
                    RenderStrategyUtility.addEventToDate(map, (DateMidnight)it.next(), event);
                }
            } else {
                RenderStrategyUtility.addEventToDate(map, start, event);
            }
        }
    };
    public static final IRenderStrategy FIRST_AND_FIRST_OF_ROW = new IRenderStrategy(){

        @Override
        public void mapEvent(Map<DateMidnight, List<IEvent>> map, IEvent event, BaseCalendarView calendar) {
            DateMidnight start;
            DateMidnight end = start = new DateMidnight((Object)event.getStartTime());
            if (event.getEndTime() != null && !event.getEndTime().equals(event.getStartTime())) {
                end = new DateMidnight((Object)event.getEndTime());
            }
            if (end.isAfter((ReadableInstant)start)) {
                DateMidnightIterator it = new DateMidnightIterator(start.toDateTime(), end.toDateTime());
                while (it.hasNext()) {
                    DateMidnight date = (DateMidnight)it.next();
                    if (!date.equals((Object)start) && date.getDayOfWeek() != calendar.getFirstDayOfWeek()) continue;
                    RenderStrategyUtility.addEventToDate(map, date, event);
                }
            } else {
                RenderStrategyUtility.addEventToDate(map, start, event);
            }
        }
    };

    public void mapEvent(Map<DateMidnight, List<IEvent>> var1, IEvent var2, BaseCalendarView var3);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RenderStrategyUtility {
        private static void addEventToDate(Map<DateMidnight, List<IEvent>> map, DateMidnight date, IEvent event) {
            List<IEvent> events = map.get(date);
            if (events == null) {
                events = new ArrayList<IEvent>();
                map.put(date, events);
            }
            events.add(event);
        }
    }
}

