/**
 * Copyright (C) 2008 Jeremy Thomerson <jeremy@thomersonfamily.com>
 *
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.wicketstuff.calendarviews.util;

/**
 * You shouldn't use this class - you should use commons-lang. We only use it internally to avoid
 * having an extra dependency for the very few things we need.
 * 
 * @author Jeremy Thomerson
 */
public class StringUtil
{

	public static final String EMPTY = "";

	/**
	 * @param string
	 *            the string to test
	 * @return true if the string is null, 0 length, or 0 length after a trim()
	 */
	public static boolean isEmpty(String string)
	{
		return string == null || string.trim().length() == 0;
	}

	public static String join(Object[] array, String separator)
	{
		if (array == null)
		{
			return null;
		}
		return join(array, separator, 0, array.length);
	}

	public static String join(Object[] array, String separator, int startIndex, int endIndex)
	{
		if (array == null)
		{
			return null;
		}
		if (separator == null)
		{
			separator = EMPTY;
		}

		// endIndex - startIndex > 0: Len = NofStrings *(len(firstString) + len(separator))
		// (Assuming that all Strings are roughly equally long)
		int bufSize = (endIndex - startIndex);
		if (bufSize <= 0)
		{
			return EMPTY;
		}

		bufSize *= ((array[startIndex] == null ? 16 : array[startIndex].toString().length()) + separator.length());

		StringBuffer buf = new StringBuffer(bufSize);

		for (int i = startIndex; i < endIndex; i++)
		{
			if (i > startIndex)
			{
				buf.append(separator);
			}
			if (array[i] != null)
			{
				buf.append(array[i]);
			}
		}
		return buf.toString();
	}
}
