/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.calendarviews;

import java.util.ArrayList;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.model.IModel;
import org.wicketstuff.calendarviews.model.ICategorizedEvent;
import org.wicketstuff.calendarviews.model.IEvent;
import org.wicketstuff.calendarviews.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddCssClassBehavior
extends Behavior {
    private static final String ATTRIBUTE_NAME = "class";
    private static final long serialVersionUID = 1L;
    private final IModel<IEvent> mEventModel;

    public AddCssClassBehavior(IModel<IEvent> event) {
        this.mEventModel = event;
    }

    public void onComponentTag(Component component, ComponentTag tag) {
        IEvent event;
        super.onComponentTag(component, tag);
        ArrayList<String> classes = new ArrayList<String>();
        String existing = tag.getAttributes().getString(ATTRIBUTE_NAME);
        if (!StringUtil.isEmpty(existing)) {
            classes.add(existing);
        }
        classes.add((event = (IEvent)this.mEventModel.getObject()).isAllDayEvent() ? "allday" : "partday");
        if (event instanceof ICategorizedEvent) {
            String css = ((ICategorizedEvent)event).getCssClassForCategory();
            classes.add(css);
        }
        tag.put(ATTRIBUTE_NAME, (CharSequence)StringUtil.join(classes.toArray(new String[classes.size()]), " "));
    }
}

