/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.calendarviews;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.joda.time.DateMidnight;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.wicketstuff.calendarviews.IRenderStrategy;
import org.wicketstuff.calendarviews.logic.DateMidnightIterator;
import org.wicketstuff.calendarviews.model.IEvent;
import org.wicketstuff.calendarviews.model.IEventProvider;
import org.wicketstuff.calendarviews.util.Comparators;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseCalendarView
extends Panel {
    private static final long serialVersionUID = 1L;
    public static final PackageResourceReference CALENDARS_CSS_REFERENCE = new PackageResourceReference(BaseCalendarView.class, "calendars.css");
    private final Date mStartDate;
    private final Date mEndDate;
    private IEventProvider mEventProvider;

    public BaseCalendarView(String id, Date startDate, Date endDate, IEventProvider eventProvider) {
        super(id);
        if (startDate == null || endDate == null || eventProvider == null) {
            throw new IllegalArgumentException("no null parameters are allowed in this constructor");
        }
        this.mStartDate = startDate;
        this.mEndDate = endDate;
        this.mEventProvider = eventProvider;
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.renderCSSReference((ResourceReference)CALENDARS_CSS_REFERENCE);
    }

    protected final Map<DateMidnight, List<IEvent>> convertToMapByDay(Collection<? extends IEvent> allEvents) {
        HashMap<DateMidnight, List<IEvent>> map = new HashMap<DateMidnight, List<IEvent>>();
        for (IEvent iEvent : allEvents) {
            this.getRenderStrategy().mapEvent(map, iEvent, this);
        }
        for (List list : map.values()) {
            Collections.sort(list, Comparators.EVENT_START_DATE_ASC_COMPARATOR);
        }
        return map;
    }

    protected IRenderStrategy getRenderStrategy() {
        return IRenderStrategy.EVERY_DAY_OF_EVENT;
    }

    protected IDataProvider<DateMidnight> createDaysDataProvider(final DateTime start, final DateTime end, final Period period) {
        return new IDataProvider<DateMidnight>(){
            private static final long serialVersionUID = 1L;

            public Iterator<? extends DateMidnight> iterator(int first, int count) {
                return BaseCalendarView.this.createDateMidnightIterator(start, end, first, count);
            }

            public IModel<DateMidnight> model(DateMidnight object) {
                return new Model((Serializable)object);
            }

            public int size() {
                return period.getDays() + 1;
            }

            public void detach() {
            }

            public String toString() {
                return "BaseCalendarView#DaysDataProvider [size: " + this.size() + "]";
            }
        };
    }

    protected Iterator<? extends DateMidnight> createDateMidnightIterator(DateTime start, DateTime end, int first, int count) {
        return new DateMidnightIterator(start, end, first, count);
    }

    protected final int getNumberOfColumns() {
        return 7;
    }

    protected final int getLastDayOfWeek() {
        return 6;
    }

    protected final int getFirstDayOfWeek() {
        return 7;
    }

    public final IEventProvider getEventProvider() {
        return this.mEventProvider;
    }

    public final Date getStartDate() {
        return this.mStartDate;
    }

    public final Date getEndDate() {
        return this.mEndDate;
    }
}

