/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.calendarviews;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.GridView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.joda.time.DateMidnight;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.calendarviews.AddCssClassBehavior;
import org.wicketstuff.calendarviews.FullWeekCalendarView;
import org.wicketstuff.calendarviews.IRenderStrategy;
import org.wicketstuff.calendarviews.modal.DateDetailPage;
import org.wicketstuff.calendarviews.model.IEvent;
import org.wicketstuff.calendarviews.model.IEventProvider;
import org.wicketstuff.calendarviews.model.TimePeriod;
import org.wicketstuff.jslibraries.JSLib;
import org.wicketstuff.jslibraries.Library;
import org.wicketstuff.jslibraries.VersionDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LargeView
extends FullWeekCalendarView {
    private static final VersionDescriptor JS_LIB_VERSION_DESCRIPTOR = VersionDescriptor.alwaysLatestOfVersion((Library)Library.PROTOTYPE, (int[])new int[]{1, 6});
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(LargeView.class);
    public static final PackageResourceReference JS = new PackageResourceReference(LargeView.class, "LargeView.js");
    private final ModalWindow mDetailModal;

    public LargeView(String id, TimePeriod tp, IEventProvider eventProvider) {
        this(id, tp.getStartDate(), tp.getEndDate(), eventProvider);
    }

    public LargeView(String id, Date startDate, Date endDate, IEventProvider eventProvider) {
        super(id, startDate, endDate, eventProvider);
        this.setOutputMarkupId(true);
        Component[] componentArray = new Component[1];
        this.mDetailModal = new ModalWindow("detailModal");
        componentArray[0] = this.mDetailModal;
        this.add(componentArray);
        this.initializeDetailModalWindow(this.mDetailModal);
        IDataProvider<DateMidnight> dp = this.createDaysDataProvider();
        Collection allEvents = (Collection)this.getEventProvider().getObject();
        Map<DateMidnight, List<IEvent>> mapOfEvents = this.convertToMapByDay(allEvents);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Data provider: " + dp);
        }
        this.add(new Component[]{new LargeGridView("rows", dp, mapOfEvents)});
    }

    protected final void initializeDetailModalWindow(ModalWindow modal) {
        modal.setCookieName("calendar-detail-modal");
    }

    @Override
    protected final IRenderStrategy getRenderStrategy() {
        return IRenderStrategy.FIRST_AND_FIRST_OF_ROW;
    }

    @Override
    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        JSLib.getHeaderContribution((VersionDescriptor)JS_LIB_VERSION_DESCRIPTOR).renderHead((Component)this, response);
        response.renderJavaScriptReference((ResourceReference)JS);
        String calID = this.getMarkupId();
        response.renderOnDomReadyJavaScript("LargeViewCalendar.initialize('" + calID + "');");
    }

    protected final ListView<IEvent> createEventListView(String id, final IModel<DateMidnight> dateModel, final int cellsLeftInRow, IModel<List<IEvent>> model) {
        return new ListView<IEvent>(id, model){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<IEvent> item) {
                WebMarkupContainer link = LargeView.this.createEventLink("link", (IModel<IEvent>)item.getModel());
                link.add(new Component[]{this.createStartTimeLabel("startTime", (IModel<IEvent>)item.getModel())});
                link.add(new Component[]{new Label("title", (IModel)new PropertyModel((Object)item.getModel(), "title"))});
                item.add(new Component[]{link});
                item.add(new Behavior[]{new HowManyDaysClassBehavior((IModel<DateMidnight>)dateModel, cellsLeftInRow, (IModel<IEvent>)item.getModel())});
                item.add(new Behavior[]{new AddCssClassBehavior((IModel<IEvent>)item.getModel())});
            }

            private Label createStartTimeLabel(String id, final IModel<IEvent> model) {
                return new Label(id, (IModel)new LoadableDetachableModel<String>(){
                    private static final long serialVersionUID = 1L;

                    protected String load() {
                        DateTime start = new DateTime((Object)((IEvent)model.getObject()).getStartTime());
                        StringBuffer sb = new StringBuffer();
                        int hr = start.getHourOfDay();
                        sb.append(hr > 12 ? hr - 12 : hr);
                        int min = start.getMinuteOfHour();
                        if (min != 0) {
                            sb.append(':');
                            if (min < 0) {
                                sb.append('0');
                            }
                            sb.append(min);
                        }
                        sb.append(hr > 12 ? (char)'p' : 'a');
                        return sb.toString();
                    }
                }){
                    private static final long serialVersionUID = 1L;

                    public boolean isVisible() {
                        return !((IEvent)model.getObject()).isAllDayEvent();
                    }
                };
            }
        };
    }

    protected void onMoreLinkClicked(AjaxRequestTarget target, IModel<DateMidnight> model, IModel<List<IEvent>> eventsModel) {
        this.mDetailModal.setPageCreator(this.getDetailModalPageCreator(model, eventsModel));
        this.mDetailModal.show(target);
    }

    protected ModalWindow.PageCreator getDetailModalPageCreator(final IModel<DateMidnight> model, final IModel<List<IEvent>> eventsModel) {
        return new ModalWindow.PageCreator(){
            private static final long serialVersionUID = 1L;

            public Page createPage() {
                return LargeView.this.createMoreDetailPage((IModel<DateMidnight>)model, (IModel<List<IEvent>>)eventsModel);
            }
        };
    }

    protected Page createMoreDetailPage(IModel<DateMidnight> model, IModel<List<IEvent>> eventsModel) {
        return new DateDetailPage(model, eventsModel, new DateDetailPage.IDateDetailPageEventLinkCreator(){
            private static final long serialVersionUID = 1L;

            @Override
            public WebMarkupContainer createEventLink(String id, IModel<IEvent> model) {
                return LargeView.this.createEventLink(id, model);
            }
        });
    }

    protected WebMarkupContainer createEventLink(String id, IModel<IEvent> model) {
        return new WebMarkupContainer(id);
    }

    public static TimePeriod createWeeksViewDates(int weeks) {
        Date start = new Date();
        Date end = new DateTime((Object)start).plusWeeks(weeks - 1).toDate();
        return new TimePeriod(start, end);
    }

    public static TimePeriod createMonthViewDates() {
        Date start = new DateTime().dayOfMonth().setCopy(1).toDate();
        Date end = new DateTime((Object)start).plusMonths(1).minusDays(1).toDate();
        return new TimePeriod(start, end);
    }

    public static TimePeriod createMonthViewDates(int month, int year) {
        Date start = new DateTime().dayOfMonth().setCopy(1).monthOfYear().setCopy(month).year().setCopy(year).toDate();
        Date end = new DateTime((Object)start).plusMonths(1).minusDays(1).toDate();
        return new TimePeriod(start, end);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HowManyDaysClassBehavior
    extends Behavior {
        private static final long serialVersionUID = 1L;
        private final int mDaysLeftInRow;
        private final IModel<DateMidnight> mDateModel;
        private final IModel<IEvent> mEventModel;

        public HowManyDaysClassBehavior(IModel<DateMidnight> dateModel, int daysLeftInRow, IModel<IEvent> model) {
            this.mDaysLeftInRow = daysLeftInRow;
            this.mDateModel = dateModel;
            this.mEventModel = model;
        }

        public void onComponentTag(Component component, ComponentTag tag) {
            super.onComponentTag(component, tag);
            DateMidnight day = (DateMidnight)this.mDateModel.getObject();
            Date end = ((IEvent)this.mEventModel.getObject()).getEndTime();
            int numberOfDays = 1;
            if (end != null) {
                DateTime endTime = new DateTime((Object)end);
                int days = Math.abs(Days.daysBetween((ReadableInstant)day, (ReadableInstant)endTime).getDays());
                numberOfDays = Math.min(days, this.mDaysLeftInRow) + 1;
            }
            tag.put("days", numberOfDays);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LargeGridView
    extends GridView<DateMidnight> {
        private static final long serialVersionUID = 1L;
        private final Map<DateMidnight, List<IEvent>> mMapOfEvents;
        private int mCounter;

        public LargeGridView(String id, IDataProvider<DateMidnight> dp, Map<DateMidnight, List<IEvent>> mapOfEvents) {
            super(id, dp);
            this.mMapOfEvents = mapOfEvents;
        }

        public int getColumns() {
            return LargeView.this.getNumberOfColumns();
        }

        protected void populateEmptyItem(Item<DateMidnight> item) {
            throw new UnsupportedOperationException("LargeView should not have any empty items");
        }

        protected void populateItem(final Item<DateMidnight> item) {
            int cell = this.mCounter++ % this.getColumns() + 1;
            int cellsLeft = this.getColumns() - cell;
            LoadableDetachableModel<List<IEvent>> eventsModel = new LoadableDetachableModel<List<IEvent>>(){
                private static final long serialVersionUID = 1L;

                protected List<IEvent> load() {
                    return (List)LargeGridView.this.mMapOfEvents.get(item.getModelObject());
                }
            };
            Label dateHeader = new Label("date", (IModel)new PropertyModel((Object)item.getModel(), "dayOfMonth"));
            dateHeader.add(new Behavior[]{new AjaxEventBehavior("onclick", (LoadableDetachableModel)eventsModel){
                private static final long serialVersionUID = 1L;
                final /* synthetic */ LoadableDetachableModel val$eventsModel;
                {
                    this.val$eventsModel = loadableDetachableModel;
                    super(x0);
                }

                protected void onEvent(AjaxRequestTarget target) {
                    LOGGER.debug("Show more events for: " + item.getModelObject());
                    LargeView.this.onMoreLinkClicked(target, (IModel<DateMidnight>)item.getModel(), (IModel<List<IEvent>>)this.val$eventsModel);
                }
            }});
            item.add(new Component[]{dateHeader});
            item.add(new Component[]{LargeView.this.createEventListView("events", (IModel<DateMidnight>)item.getModel(), cellsLeft, (IModel<List<IEvent>>)eventsModel)});
        }

        protected void onDetach() {
            super.onDetach();
        }
    }
}

