/*
 * Decompiled with CFR 0.152.
 */
package wicket.contrib.jasperreports;

import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRGraphics2DExporter;
import net.sf.jasperreports.engine.export.JRGraphics2DExporterParameter;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.html.DynamicWebResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import wicket.contrib.jasperreports.JRResource;

public final class JRImageResource
extends JRResource {
    private static Logger log = LoggerFactory.getLogger(JRImageResource.class);
    private int type = 1;
    private float zoomRatio = 1.0f;
    private String format = "png";

    public JRImageResource() {
    }

    public JRImageResource(InputStream report) {
        super(report);
    }

    public JRImageResource(URL report) {
        super(report);
    }

    public JRImageResource(File report) {
        super(report);
    }

    public final JRAbstractExporter newExporter() {
        throw new UnsupportedOperationException("this method is not used in this implementation");
    }

    protected DynamicWebResource.ResourceState getResourceState() {
        try {
            long t1 = System.currentTimeMillis();
            JasperPrint print = this.newJasperPrint();
            JRGraphics2DExporter exporter = new JRGraphics2DExporter();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)print);
            exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)baos);
            int width = (int)((float)print.getPageWidth() * this.getZoomRatio());
            int height = (int)((float)print.getPageHeight() * this.getZoomRatio());
            BufferedImage image = new BufferedImage(width, height, this.type);
            exporter.setParameter((JRExporterParameter)JRGraphics2DExporterParameter.GRAPHICS_2D, (Object)image.getGraphics());
            exporter.setParameter((JRExporterParameter)JRGraphics2DExporterParameter.ZOOM_RATIO, (Object)new Float(this.zoomRatio));
            exporter.exportReport();
            final byte[] data = this.toImageData(image);
            long t2 = System.currentTimeMillis();
            log.info("loaded report data; bytes: " + data.length + " in " + (t2 - t1) + " miliseconds");
            return new DynamicWebResource.ResourceState(){

                public int getLength() {
                    return data.length;
                }

                public byte[] getData() {
                    return data;
                }

                public String getContentType() {
                    return "image/" + JRImageResource.this.format;
                }
            };
        }
        catch (JRException e) {
            throw new WicketRuntimeException((Throwable)e);
        }
    }

    protected byte[] toImageData(BufferedImage image) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ImageWriter writer = ImageIO.getImageWritersByFormatName(this.format).next();
            writer.setOutput(ImageIO.createImageOutputStream(out));
            writer.write(image);
            return out.toByteArray();
        }
        catch (IOException e) {
            throw new WicketRuntimeException("Unable to convert dynamic image to stream", (Throwable)e);
        }
    }

    public String getContentType() {
        return "image/" + this.format;
    }

    public float getZoomRatio() {
        return this.zoomRatio;
    }

    public void setZoomRatio(float ratio) {
        this.zoomRatio = ratio;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getExtension() {
        return this.getFormat();
    }
}

