/*
 * Decompiled with CFR 0.152.
 */
package wicket.contrib.jasperreports;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.html.DynamicWebResource;
import org.apache.wicket.protocol.http.WebResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JRResource
extends DynamicWebResource {
    private static Logger log = LoggerFactory.getLogger(JRResource.class);
    private IDatabaseConnectionProvider connectionProvider;
    private JasperReportFactory jasperReportFactory;
    private transient JasperReport jasperReport;
    private Map reportParameters;
    private JRDataSource reportDataSource;
    private String fileName;

    public JRResource() {
        this.setCacheable(false);
    }

    public JRResource(final InputStream report) {
        this(new JasperReportFactory(){

            public JasperReport newJasperReport() throws JRException {
                return (JasperReport)JRLoader.loadObject((InputStream)report);
            }
        });
    }

    public JRResource(final URL report) {
        this(new JasperReportFactory(){

            public JasperReport newJasperReport() throws JRException {
                return (JasperReport)JRLoader.loadObject((URL)report);
            }
        });
    }

    public JRResource(final File report) {
        this(new JasperReportFactory(){

            public JasperReport newJasperReport() throws JRException {
                return (JasperReport)JRLoader.loadObject((File)report);
            }
        });
    }

    private JRResource(JasperReportFactory factory) {
        this.setCacheable(false);
        this.jasperReportFactory = factory;
    }

    public JasperReport getJasperReport() {
        if (this.jasperReport == null && this.jasperReportFactory != null) {
            try {
                this.setJasperReport(this.jasperReportFactory.newJasperReport());
            }
            catch (JRException e) {
                throw new WicketRuntimeException((Throwable)e);
            }
        }
        return this.jasperReport;
    }

    public final void setJasperReport(JasperReport report) {
        this.jasperReport = report;
    }

    public Map getReportParameters() {
        return new HashMap(this.reportParameters);
    }

    public final JRResource setReportParameters(Map params) {
        this.reportParameters = params;
        return this;
    }

    public JRDataSource getReportDataSource() {
        return this.reportDataSource;
    }

    public JRResource setReportDataSource(JRDataSource dataSource) {
        this.reportDataSource = dataSource;
        return this;
    }

    public IDatabaseConnectionProvider getConnectionProvider() {
        return this.connectionProvider;
    }

    public final JRResource setConnectionProvider(IDatabaseConnectionProvider provider) {
        this.connectionProvider = provider;
        return this;
    }

    public String getFileName() {
        if (this.fileName == null) {
            this.fileName = this.getJasperReport().getName() + "." + this.getExtension();
        }
        return this.fileName;
    }

    public final JRResource setFileName(String name) {
        this.fileName = name;
        return this;
    }

    public abstract JRAbstractExporter newExporter();

    protected DynamicWebResource.ResourceState getResourceState() {
        try {
            long t1 = System.currentTimeMillis();
            JasperPrint print = this.newJasperPrint();
            JRAbstractExporter exporter = this.newExporter();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)print);
            exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)baos);
            exporter.exportReport();
            final byte[] data = baos.toByteArray();
            if (log.isDebugEnabled()) {
                long t2 = System.currentTimeMillis();
                log.debug("loaded report data; bytes: " + data.length + " in " + (t2 - t1) + " miliseconds");
            }
            return new DynamicWebResource.ResourceState(){

                public int getLength() {
                    return data.length;
                }

                public byte[] getData() {
                    return data;
                }

                public String getContentType() {
                    return JRResource.this.getContentType();
                }
            };
        }
        catch (JRException e) {
            throw new WicketRuntimeException((Throwable)e);
        }
    }

    public abstract String getContentType();

    public abstract String getExtension();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JasperPrint newJasperPrint() throws JRException {
        JasperPrint jasperPrint;
        JasperReport report = this.getJasperReport();
        Map params = this.getReportParameters();
        JRDataSource dataSource = this.getReportDataSource();
        if (dataSource != null) {
            jasperPrint = JasperFillManager.fillReport((JasperReport)report, (Map)params, (JRDataSource)dataSource);
        } else {
            IDatabaseConnectionProvider provider = null;
            try {
                provider = this.getConnectionProvider();
                if (provider == null) {
                    throw new IllegalStateException("JasperReportsResources must either have a JRDataSource, or a JDBC Connection provided");
                }
                jasperPrint = JasperFillManager.fillReport((JasperReport)report, (Map)params, (Connection)provider.get());
            }
            finally {
                if (provider != null) {
                    provider.release();
                }
            }
        }
        return jasperPrint;
    }

    protected void setHeaders(WebResponse response) {
        super.setHeaders(response);
        String name = this.getFileName();
        if (name != null) {
            response.setHeader("Content-Disposition", "attachment; filename=\"" + name + "\"");
        }
    }

    private static interface JasperReportFactory
    extends Serializable {
        public JasperReport newJasperReport() throws JRException;
    }

    public static interface IDatabaseConnectionProvider
    extends Serializable {
        public Connection get();

        public void release();
    }
}

