/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jslibraries;

import org.apache.wicket.Application;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.behavior.HeaderContributor;
import org.apache.wicket.markup.html.JavascriptPackageResource;
import org.wicketstuff.jslibraries.JSReference;
import org.wicketstuff.jslibraries.Provider;
import org.wicketstuff.jslibraries.VersionDescriptor;
import org.wicketstuff.jslibraries.util.Assert;
import org.wicketstuff.jslibraries.util.WicketDeploymentState;

public class JSLib {
    private static final MetaDataKey<Provider[]> PROVIDER_KEY = new MetaDataKey<Provider[]>(){};

    private JSLib() {
    }

    public static void setOverrideProviders(Application app, Provider ... providers) {
        Assert.parameterNotNull(app, "app");
        Assert.parameterNotNull(providers, "providers");
        app.setMetaData(PROVIDER_KEY, (Object)providers);
    }

    public static HeaderContributor getHeaderContribution(VersionDescriptor versionDescriptor, Provider ... providers) {
        return JSLib.getHeaderContribution(versionDescriptor, WicketDeploymentState.isProduction(), providers);
    }

    public static HeaderContributor getHeaderContribution(VersionDescriptor versionDescriptor, boolean production, Provider ... providers) {
        ResourceReference reference;
        Provider[] prov = (Provider[])Application.get().getMetaData(PROVIDER_KEY);
        if (prov == null) {
            prov = providers;
        }
        if (prov != null) {
            for (Provider provider : prov) {
                HeaderContributor hc = provider.getHeaderContributor(versionDescriptor, production);
                if (hc == null) continue;
                return hc;
            }
        }
        if ((reference = JSReference.getReference(versionDescriptor, production)) != null) {
            return JavascriptPackageResource.getHeaderContribution((ResourceReference)reference);
        }
        return null;
    }
}

