/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jslibraries;

import org.apache.wicket.ResourceReference;
import org.wicketstuff.jslibraries.Library;
import org.wicketstuff.jslibraries.LocalProvider;
import org.wicketstuff.jslibraries.Version;
import org.wicketstuff.jslibraries.VersionDescriptor;
import org.wicketstuff.jslibraries.util.Assert;
import org.wicketstuff.jslibraries.util.WicketDeploymentState;

public class JSReference {
    private JSReference() {
    }

    public static ResourceReference getReference(VersionDescriptor versionDescriptor) {
        return JSReference.getReference(versionDescriptor, WicketDeploymentState.isProduction());
    }

    public static ResourceReference getReference(VersionDescriptor versionDescriptor, boolean production) {
        Assert.parameterNotNull(versionDescriptor, "versionDescriptor");
        Version version = versionDescriptor.getVersion(LocalProvider.DEFAULT);
        if (version == null) {
            return null;
        }
        Library lib = versionDescriptor.getLibrary();
        StringBuffer sb = JSReference.createFileName(lib, version, production);
        return new ResourceReference(JSReference.class, sb.toString());
    }

    public static StringBuffer createFileName(Library lib, Version version, boolean production) {
        String productionSignifier;
        Assert.parameterNotNull((Object)lib, "lib");
        Assert.parameterNotNull(version, "version");
        StringBuffer sb = new StringBuffer();
        sb.append("js/").append(LocalProvider.DEFAULT.getLocalFileName(lib)).append('-');
        for (int i = 0; i < version.getNumbers().length; ++i) {
            sb.append(version.getNumbers()[i]);
            if (i >= version.getNumbers().length - 1) continue;
            sb.append('.');
        }
        if (production && (productionSignifier = LocalProvider.DEFAULT.getProductionSignifier(lib)) != null) {
            sb.append(productionSignifier);
        }
        sb.append(".js");
        return sb;
    }
}

