/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jslibraries;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.wicketstuff.jslibraries.LibraryData;
import org.wicketstuff.jslibraries.LocalProvider;
import org.wicketstuff.jslibraries.Provider;
import org.wicketstuff.jslibraries.Version;
import org.wicketstuff.jslibraries.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Library {
    DOJO,
    EXT_CORE,
    JQUERY,
    JQUERY_UI,
    MOOTOOLS_CORE,
    MOOTOOLS_MORE,
    PROTOTYPE,
    SCRIPTACULOUS,
    SWFOBJECT,
    YUI;

    private Map<Provider, SortedSet<Version>> providerInfo = new HashMap<Provider, SortedSet<Version>>();

    static void register(Library lib, Provider provider, int[] ... versions) {
        Assert.parameterNotNull((Object)lib, "lib");
        Assert.parameterNotNull(provider, "provider");
        Assert.parameterNotNull(versions, "versions");
        lib.register(provider, versions);
    }

    private void register(Provider provider, int[] ... versions) {
        Assert.parameterNotNull(provider, "provider");
        Assert.parameterNotNull(versions, "versions");
        SortedSet<Version> versionsAvailable = this.providerInfo.get(provider);
        if (versionsAvailable == null) {
            versionsAvailable = new TreeSet<Version>();
            this.providerInfo.put(provider, versionsAvailable);
        }
        for (int i = 0; i < versions.length; ++i) {
            Version v = new Version(versions[i]);
            versionsAvailable.add(v);
        }
    }

    public Set<Version> getVersions(Provider provider) {
        Assert.parameterNotNull(provider, "provider");
        SortedSet<Version> sortedSet = this.providerInfo.get(provider);
        if (sortedSet == null) {
            return Collections.EMPTY_SET;
        }
        return sortedSet;
    }

    @Deprecated
    public String getLibraryName() {
        return LocalProvider.DEFAULT.getLocalFileName(this);
    }

    int getMaxVersionDepth(LocalProvider provider) {
        Assert.parameterNotNull(provider, "provider");
        int depth = 0;
        for (Version version : this.getVersions(provider)) {
            depth = version.getNumbers().length > depth ? version.getNumbers().length : depth;
        }
        return depth;
    }

    static {
        new LibraryData();
    }
}

