/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jslibraries;

import org.wicketstuff.jslibraries.Library;
import org.wicketstuff.jslibraries.LocalProvider;
import org.wicketstuff.jslibraries.Provider;
import org.wicketstuff.jslibraries.Version;
import org.wicketstuff.jslibraries.util.Assert;

public class VersionDescriptor {
    private final Library mLibrary;
    private final Integer[] mVersions;
    private final boolean mStopOnFirstMatch;
    private Version mMatch;

    private VersionDescriptor(Library library, boolean stopOnFirstMatch, Integer ... versions) {
        Assert.parameterNotNull((Object)library, "library");
        Assert.parameterNotNull(versions, "versions");
        this.mLibrary = library;
        this.mVersions = versions;
        this.mStopOnFirstMatch = stopOnFirstMatch;
    }

    public Library getLibrary() {
        return this.mLibrary;
    }

    public Version getVersion(Provider provider) {
        Assert.parameterNotNull(provider, "provider");
        for (Version version : this.mLibrary.getVersions(provider)) {
            if (!this.matches(version)) continue;
            this.mMatch = version;
            if (!this.mStopOnFirstMatch) continue;
            break;
        }
        return this.mMatch;
    }

    private boolean matches(Version version) {
        Assert.parameterNotNull(version, "version");
        if (this.mVersions.length > version.getNumbers().length) {
            return false;
        }
        for (int i = 0; i < this.mVersions.length; ++i) {
            if (this.mVersions[i] == null || this.mVersions[i].equals(version.getNumbers()[i])) continue;
            return false;
        }
        return true;
    }

    public static VersionDescriptor alwaysLatest(Library lib) {
        return VersionDescriptor.alwaysLatestOfVersion(lib, new int[0]);
    }

    public static VersionDescriptor exactVersion(Library lib, int ... version) {
        Assert.parameterNotNull((Object)lib, "lib");
        Integer[] nums = new Integer[version.length];
        for (int i = 0; i < version.length; ++i) {
            nums[i] = version[i];
        }
        return new VersionDescriptor(lib, true, nums);
    }

    public static VersionDescriptor alwaysLatestOfVersion(Library lib, int ... baseVersion) {
        Assert.parameterNotNull((Object)lib, "lib");
        Integer[] nums = new Integer[lib.getMaxVersionDepth(LocalProvider.DEFAULT)];
        for (int i = 0; i < nums.length; ++i) {
            nums[i] = i < baseVersion.length ? Integer.valueOf(baseVersion[i]) : null;
        }
        return new VersionDescriptor(lib, false, nums);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mLibrary == null ? 0 : this.mLibrary.hashCode());
        result = 31 * result + (this.mMatch == null ? 0 : this.mMatch.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VersionDescriptor other = (VersionDescriptor)obj;
        if (this.mLibrary == null ? other.mLibrary != null : !this.mLibrary.equals((Object)other.mLibrary)) {
            return false;
        }
        return !(this.mMatch == null ? other.mMatch != null : !this.mMatch.equals(other.mMatch));
    }
}

