/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.minis.mootipbehavior;

import java.io.Serializable;
import java.util.HashMap;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.behavior.AbstractBehavior;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.resources.CompressedResourceReference;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.template.PackagedTextTemplate;
import org.apache.wicket.util.template.TextTemplate;
import org.wicketstuff.minis.mootipbehavior.MootipAjaxListener;
import org.wicketstuff.minis.mootipbehavior.MootipPanel;
import org.wicketstuff.minis.mootipbehavior.MootipSettings;

public class MootipBehaviour
extends AbstractBehavior {
    private static final long serialVersionUID = 1L;
    private MootipAjaxListener mootipAjaxListener = null;
    private final TextTemplate mooTipTemplate = new PackagedTextTemplate(MootipBehaviour.class, "MootipBehaviour.js");
    private MootipSettings mootipSettings = new MootipSettings();
    private Component component;
    private boolean addTitle = false;
    private String content = "";
    private String title = "";
    private boolean ajax = false;
    private MootipPanel panel = null;
    private boolean contributeCSS = true;

    public boolean isAjax() {
        return this.ajax;
    }

    public MootipBehaviour(String title, String content) {
        this.addTitle = true;
        this.content = content;
        this.title = title;
    }

    public void setMootipSettings(MootipSettings mootipSettings) {
        this.mootipSettings = mootipSettings;
    }

    public MootipBehaviour(String title, String content, boolean contribute) {
        this(title, content);
        this.contributeCSS = contribute;
    }

    public MootipBehaviour(MootipPanel panel) {
        this.ajax = true;
        this.panel = panel;
    }

    public MootipBehaviour(MootipPanel panel, boolean contribute) {
        this(panel);
        this.contributeCSS = contribute;
    }

    public void bind(Component component) {
        super.bind(component);
        this.component = component;
        this.component.setOutputMarkupId(true);
        if (this.addTitle && !this.isAjax()) {
            component.add(new IBehavior[]{new AttributeModifier("title", true, (IModel)new Model((Serializable)((Object)(this.title + "::" + this.content))))});
        }
        if (this.isAjax()) {
            this.mootipAjaxListener = new MootipAjaxListener(this.panel);
            this.component.add(new IBehavior[]{new MootipAjaxListener(this.panel)});
            component.add(new IBehavior[]{new AttributeModifier("title", true, (IModel)new Model((Serializable)((Object)("CALLBACK:mootipAjax" + this.getEscapedComponentMarkupId() + "()"))))});
        }
        component.add(new IBehavior[]{new AttributeModifier("class", true, (IModel)new Model((Serializable)((Object)("toolTipImg" + this.getEscapedComponentMarkupId()))))});
        component.setOutputMarkupId(true);
    }

    private String generateJS(TextTemplate textTemplate) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        String widgetId = this.getEscapedComponentMarkupId();
        variables.put("id", widgetId);
        variables.put("widgetId", ".toolTipImg" + this.getEscapedComponentMarkupId());
        variables.put("maxTitleChars", this.mootipSettings.getMaxTitleChars());
        variables.put("evalAlways", this.mootipSettings.isEvalAlways());
        variables.put("showOnClick", this.mootipSettings.isShowOnClick());
        variables.put("showOnMouseEnter", this.mootipSettings.isShowOnMouseEnter());
        variables.put("showDelay", this.mootipSettings.getShowDelay());
        variables.put("hideDelay", this.mootipSettings.getHideDelay());
        variables.put("className", this.mootipSettings.getClassName());
        variables.put("offsetX", Math.round(this.mootipSettings.getOffsets().getX()));
        variables.put("offsetY", Math.round(this.mootipSettings.getOffsets().getY()));
        variables.put("fixed", this.mootipSettings.isFixed());
        textTemplate.interpolate(variables);
        return textTemplate.asString();
    }

    protected final String getEscapedComponentMarkupId() {
        return this.component.getMarkupId().replaceAll("\\W", "");
    }

    public void renderHead(IHeaderResponse response) {
        response.renderJavascriptReference((ResourceReference)new CompressedResourceReference(MootipBehaviour.class, "mootools.v1.11.js"));
        response.renderJavascriptReference((ResourceReference)new CompressedResourceReference(MootipBehaviour.class, "mootips.v1.11.js"));
        if (this.contributeCSS) {
            response.renderCSSReference((ResourceReference)new CompressedResourceReference(MootipBehaviour.class, "tip.css"));
        }
        response.renderOnLoadJavascript(this.generateJS(this.mooTipTemplate));
    }
}

