/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.minis.prototipbehaviour;

import org.apache.wicket.Component;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.AbstractBehavior;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.resources.CompressedResourceReference;
import org.wicketstuff.minis.prototipbehaviour.JS_TYPE;
import org.wicketstuff.minis.prototipbehaviour.PrototipSettings;

public class PrototipBehaviour
extends AbstractBehavior {
    private static final long serialVersionUID = 1L;
    protected Component source;
    protected String tooltip = null;
    protected Component tooltipComponent = null;
    protected PrototipSettings settings = null;
    protected boolean overrideHeaderContributor = false;
    protected String title = null;
    protected boolean onLoad = true;
    protected static JS_TYPE selectedJsType = JS_TYPE.MIN;

    public PrototipBehaviour() {
    }

    public PrototipBehaviour(String tooltip) {
        this.tooltip = tooltip;
    }

    public PrototipBehaviour(Component panel) {
        this.tooltipComponent = panel;
        panel.setOutputMarkupId(true);
    }

    public void renderHead(IHeaderResponse response) {
        if (this.onLoad) {
            response.renderOnLoadJavascript(this.toJavascript());
        } else {
            response.renderOnDomReadyJavascript(this.toJavascript());
        }
        if (!this.overrideHeaderContributor) {
            response.renderCSSReference((ResourceReference)new CompressedResourceReference(PrototipBehaviour.class, "prototip.css"), "screen");
            switch (selectedJsType) {
                case NORMAL: {
                    response.renderJavascriptReference((ResourceReference)new CompressedResourceReference(PrototipBehaviour.class, "prototip.js"));
                    break;
                }
                case MIN: {
                    response.renderJavascriptReference((ResourceReference)new CompressedResourceReference(PrototipBehaviour.class, "prototip-min.js"));
                }
            }
        }
    }

    public void bind(Component component) {
        super.bind(component);
        this.source = component;
        this.source.setOutputMarkupId(true);
    }

    public void remove(AjaxRequestTarget target) {
        if (this.source != null) {
            StringBuilder removeJs = new StringBuilder();
            removeJs.append("Tips.remove($('").append(this.source.getMarkupId()).append("'));");
            target.appendJavascript(removeJs.toString());
        }
    }

    public void hide(AjaxRequestTarget target) {
        if (this.source != null) {
            StringBuilder hideJs = new StringBuilder();
            hideJs.append("Tips.hide($('").append(this.source.getMarkupId()).append("'));");
            target.appendJavascript(hideJs.toString());
        }
    }

    protected String toJavascript() {
        StringBuilder script = new StringBuilder();
        String optionString = null;
        if (this.settings != null) {
            optionString = this.settings.getOptionsString(this.title);
        }
        if (this.tooltip != null) {
            script.append("new Tip($('").append(this.source.getMarkupId()).append("'),'").append(this.tooltip).append("'");
        } else if (this.tooltipComponent != null) {
            script.append("new Tip($('").append(this.source.getMarkupId()).append("'),$('").append(this.tooltipComponent.getMarkupId()).append("')");
        }
        if (optionString != null && !optionString.equals("")) {
            script.append(", ").append(optionString);
        }
        script.append(");");
        return script.toString();
    }

    public Component getSource() {
        return this.source;
    }

    public PrototipBehaviour setSource(Component source) {
        this.source = source;
        return this;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public PrototipBehaviour setTooltip(String tooltip) {
        this.tooltip = tooltip;
        this.tooltipComponent = null;
        return this;
    }

    public Component getTooltipComponent() {
        return this.tooltipComponent;
    }

    public PrototipBehaviour setTooltipComponent(Component tooltipComponent) {
        this.tooltipComponent = tooltipComponent;
        this.tooltipComponent.setOutputMarkupId(true);
        this.tooltip = null;
        return this;
    }

    public PrototipSettings getSettings() {
        return this.settings;
    }

    public PrototipBehaviour setSettings(PrototipSettings settings) {
        this.settings = settings;
        return this;
    }

    public boolean isOverrideHeaderContributor() {
        return this.overrideHeaderContributor;
    }

    public PrototipBehaviour setOverrideHeaderContributor(boolean overrideHeaderContributor) {
        this.overrideHeaderContributor = overrideHeaderContributor;
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public PrototipBehaviour setTitle(String title) {
        this.title = title;
        return this;
    }

    public static JS_TYPE getSelectedJsType() {
        return selectedJsType;
    }

    public static void setSelectedJsType(JS_TYPE selectedJsType) {
        PrototipBehaviour.selectedJsType = selectedJsType;
    }

    public boolean isOnLoad() {
        return this.onLoad;
    }

    public void setOnLoad(boolean onLoad) {
        this.onLoad = onLoad;
    }
}

