/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.minis.reflection;

import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.behavior.AbstractBehavior;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.resources.JavascriptResourceReference;
import org.apache.wicket.util.string.AppendingStringBuffer;

public class ReflectionBehavior
extends AbstractBehavior {
    private static final long serialVersionUID = 1L;
    public static final ResourceReference REFLECTION_JS = new JavascriptResourceReference(ReflectionBehavior.class, "reflection.js");
    private static final String REFLECTION_MARKER = "reflect";
    private static final String REFLECTION_OPACITY_MARKER = "ropacity";
    private static final String REFLECTION_HEIGHT_MARKER = "rheight";
    private Integer reflectionOpacity = null;
    private Integer reflectionHeight = null;
    private List components = new ArrayList();

    public ReflectionBehavior() {
    }

    public ReflectionBehavior(Integer height, Integer opacity) {
        this.setReflectionHeight(height);
        this.setReflectionOpacity(opacity);
    }

    public void bind(Component component) {
        super.bind(component);
        component.setOutputMarkupId(true);
        this.components.add(component);
    }

    public void setReflectionHeight(Integer height) {
        this.reflectionHeight = height;
    }

    public void setReflectionOpacity(Integer opacity) {
        this.reflectionOpacity = opacity;
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.renderJavascriptReference(REFLECTION_JS);
        AppendingStringBuffer sb = new AppendingStringBuffer((CharSequence)"");
        for (Component component : this.components) {
            if (!component.isVisibleInHierarchy()) continue;
            sb.append((Object)Javascript.show(component.getMarkupId(), this.reflectionOpacity, this.reflectionHeight));
            sb.append("\n");
        }
        response.renderOnLoadJavascript(sb.toString());
    }

    public static class Javascript {
        private Javascript() {
        }

        public static CharSequence show(String id, Integer opacity, Integer height) {
            AppendingStringBuffer sb2 = new AppendingStringBuffer();
            sb2.append("Reflection.add(document.getElementById('");
            sb2.append(id);
            sb2.append("'), { ");
            String komma = "";
            if (height != null) {
                sb2.append("height: ").append(height.toString()).append("/100");
                komma = ",";
            }
            if (opacity != null) {
                sb2.append(komma);
                sb2.append("opacity: ").append(opacity.toString()).append("/100");
            }
            sb2.append("});");
            return sb2;
        }

        public static CharSequence hide(String id) {
            AppendingStringBuffer sb2 = new AppendingStringBuffer();
            sb2.append("Reflection.remove(document.getElementById('");
            sb2.append(id);
            sb2.append("');");
            return sb2;
        }
    }
}

