/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.minis.request.target.coding;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.wicket.application.DefaultClassResolver;
import org.apache.wicket.application.IClassResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.ClassMetadata;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.SimpleMetadataReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CaseInsensitiveClassResolver
implements IClassResolver {
    private static final Logger logger = LoggerFactory.getLogger(CaseInsensitiveClassResolver.class);
    private DefaultClassResolver resolver = new DefaultClassResolver();
    private Map<String, Map<String, Class<?>>> cache = new HashMap();

    public Iterator<URL> getResources(String name) {
        return this.resolver.getResources(name);
    }

    public Class<?> resolveClass(String classname) throws ClassNotFoundException {
        Class<?> clazz = null;
        try {
            clazz = this.resolver.resolveClass(classname);
        }
        catch (ClassNotFoundException e1) {
            clazz = this.resolveClassCaseInsensitive(classname);
        }
        catch (NoClassDefFoundError e2) {
            clazz = this.resolveClassCaseInsensitive(classname);
        }
        if (clazz == null) {
            throw new ClassNotFoundException("Unable to resolve class for name " + classname);
        }
        return clazz;
    }

    public Class<?> resolveClassCaseInsensitive(String classname) {
        String packageName;
        if (logger.isDebugEnabled()) {
            logger.debug("Class not found for " + classname + ".  Trying to look up case-insensitive.");
        }
        if (!this.cache.containsKey(packageName = classname.substring(0, classname.lastIndexOf(46)))) {
            this.cache.put(packageName, this.scan(this.getPatternForPackage(packageName)));
        }
        return this.cache.get(packageName).get(classname.toLowerCase());
    }

    public String getPatternForPackage(String packageName) {
        if (packageName == null) {
            packageName = "";
        }
        if (!(packageName = packageName.replace('.', '/')).endsWith("/")) {
            packageName = packageName + '/';
        }
        return "classpath*:" + packageName + "**/*.class";
    }

    private Map<String, Class<?>> scan(String pattern) {
        Resource[] resources;
        HashMap classMap = new HashMap();
        PathMatchingResourcePatternResolver match = new PathMatchingResourcePatternResolver();
        try {
            resources = match.getResources(pattern);
            logger.debug("Found " + resources.length + " resource(s) for: " + pattern);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        SimpleMetadataReaderFactory f = new SimpleMetadataReaderFactory();
        for (Resource r : resources) {
            MetadataReader meta = null;
            try {
                meta = f.getMetadataReader(r);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to get MetadataReader for " + r, e);
            }
            try {
                ClassMetadata cmd = meta.getClassMetadata();
                String classname = cmd.getClassName();
                try {
                    classMap.put(classname.toLowerCase(), this.getClass().getClassLoader().loadClass(classname));
                }
                catch (ClassNotFoundException e) {
                    logger.error("Error loading class for name " + classname);
                }
            }
            catch (Throwable e) {
                logger.error("Unknown Error.", e);
            }
        }
        return classMap;
    }
}

