/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.minis.spinner;

import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.wicket.Component;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.Response;
import org.apache.wicket.behavior.AbstractBehavior;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.resources.JavascriptResourceReference;
import org.apache.wicket.util.string.Strings;

public class Spinner
extends AbstractBehavior {
    private static final long serialVersionUID = 1L;
    private static final ResourceReference JS = new JavascriptResourceReference(Spinner.class, "spinner.js");
    private static final ResourceReference CSS = new ResourceReference(Spinner.class, "spinner.css");
    private Component component;

    public void bind(Component component) {
        if (this.component != null) {
            throw new IllegalStateException("Spinner can not be added to more than one component.");
        }
        if (!(component instanceof TextField)) {
            throw new IllegalArgumentException("Spinner can only be added to a TextField.");
        }
        this.component = component.setOutputMarkupId(true);
    }

    public void renderHead(IHeaderResponse response) {
        response.renderJavascriptReference(JS);
        response.renderCSSReference(CSS);
        Properties p = new Properties();
        this.configure(p);
        String downId = this.getSpinDownComponent() == null ? this.getMarkupId() + "Down" : this.getSpinDownComponent().getMarkupId();
        String upId = this.getSpinUpComponent() == null ? this.getMarkupId() + "Up" : this.getSpinUpComponent().getMarkupId();
        response.renderOnDomReadyJavascript("new Wicket.Spinner('" + this.component.getMarkupId() + "', '" + upId + "', '" + downId + "', {" + this.propertiesToJavascriptArray(p) + "})");
    }

    private String propertiesToJavascriptArray(Properties p) {
        StringBuffer sb = new StringBuffer();
        Iterator<Map.Entry<Object, Object>> i = p.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<Object, Object> entry = i.next();
            sb.append(entry.getKey());
            Object value = entry.getValue();
            if (value instanceof CharSequence) {
                sb.append(":\"");
                sb.append(Strings.toEscapedUnicode((String)value.toString()));
                sb.append("\"");
            } else if (value instanceof CharSequence[]) {
                sb.append(":[");
                CharSequence[] valueArray = (CharSequence[])value;
                for (int j = 0; j < valueArray.length; ++j) {
                    CharSequence tmpValue = valueArray[j];
                    if (j > 0) {
                        sb.append(",");
                    }
                    if (tmpValue == null) continue;
                    sb.append("\"");
                    sb.append(Strings.toEscapedUnicode((String)((Object)tmpValue).toString()));
                    sb.append("\"");
                }
                sb.append("]");
            } else {
                sb.append(":");
                sb.append(Strings.toEscapedUnicode((String)String.valueOf(value)));
            }
            if (!i.hasNext()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public void beforeRender(Component component) {
        if (this.getSpinDownComponent() == null) {
            Response response = component.getResponse();
            response.write((CharSequence)"<span class='spinnerContainer'>");
            response.write((CharSequence)("<span id='" + this.getMarkupId() + "Down'>-</span>"));
        }
    }

    public void onRendered(Component component) {
        if (this.getSpinUpComponent() == null) {
            Response response = component.getResponse();
            response.write((CharSequence)("<span id='" + this.getMarkupId() + "Up'>+</span></span>"));
        }
    }

    private String getMarkupId() {
        return this.component.getMarkupId() + "-Spinner";
    }

    protected Component getSpinDownComponent() {
        return null;
    }

    protected Component getSpinUpComponent() {
        return null;
    }

    protected void configure(Properties p) {
    }
}

