/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.minis.styleswitcher;

import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.IClusterable;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.behavior.AbstractBehavior;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.resources.JavascriptResourceReference;

public class StyleSwitcher
extends AbstractBehavior {
    private static final ResourceReference SS_JS = new JavascriptResourceReference(StyleSwitcher.class, "styleswitcher.js");
    private List<TitledResourceReferenceTuple> stylesheets = new ArrayList<TitledResourceReferenceTuple>();

    public void addStylesheet(String title, ResourceReference reference) {
        this.stylesheets.add(new TitledResourceReferenceTuple(title, reference));
    }

    public void renderHead(IHeaderResponse response) {
        response.renderJavascriptReference(SS_JS);
        for (TitledResourceReferenceTuple stylesheet : this.stylesheets) {
            StringBuilder link = new StringBuilder(128);
            link.append("<link rel=\"alternate stylesheet\" type=\"text/css\" href=\"");
            link.append(RequestCycle.get().urlFor(stylesheet.getReference()));
            link.append("\" title=\"");
            link.append(stylesheet.getTitle());
            link.append("\"/>");
            response.renderString((CharSequence)link.toString());
        }
    }

    private static class TitledResourceReferenceTuple
    implements IClusterable {
        private String title;
        private ResourceReference reference;

        public TitledResourceReferenceTuple(String name, ResourceReference reference) {
            this.title = name;
            this.reference = reference;
        }

        public String getTitle() {
            return this.title;
        }

        public ResourceReference getReference() {
            return this.reference;
        }
    }

    public static class Javascript {
        private Javascript() {
        }

        public static String forActivatingStylesheet(String title) {
            return "StyleSwitcher.setActiveStyleSheet('" + title + "');";
        }
    }
}

