/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.minis.veil;

import org.apache.wicket.Component;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.behavior.AbstractBehavior;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.resources.JavascriptResourceReference;

public class VeilResources
extends AbstractBehavior
implements IHeaderContributor {
    private static final ResourceReference JS = new JavascriptResourceReference(VeilResources.class, "wicket-veil.js");
    private static final ResourceReference CSS = new ResourceReference(VeilResources.class, "wicket-veil.css");
    public static final String DEFAULT_CSS_CLASS_NAME = "wicket-veil";

    public void bind(Component component) {
        super.bind(component);
        component.setOutputMarkupId(true);
    }

    public void renderHead(IHeaderResponse response) {
        response.renderJavascriptReference(JS);
        response.renderCSSReference(CSS);
    }

    public static class Javascript {
        private Javascript() {
        }

        public static String show(Component component, String className) {
            return Generic.show(component.getMarkupId(), className);
        }

        public static String show(Component component) {
            return Generic.show(component.getMarkupId());
        }

        public static String toggle(Component component, String className) {
            return Generic.toggle(component.getMarkupId(), className);
        }

        public static String toggle(Component component) {
            return Generic.toggle(component.getMarkupId());
        }

        public static String hide(Component component) {
            return Generic.hide(component.getMarkupId());
        }

        public static class Generic {
            private Generic() {
            }

            public static String show(String markupId, String className) {
                return "Wicket.Veil.show('" + markupId + "', {className:'" + className + "'});";
            }

            public static String show(String markupId) {
                return Generic.show(markupId, VeilResources.DEFAULT_CSS_CLASS_NAME);
            }

            public static String toggle(String markupId, String className) {
                return "Wicket.Veil.toggle('" + markupId + "', {className:'" + className + "'});";
            }

            public static String toggle(String markupId) {
                return Generic.toggle(markupId, VeilResources.DEFAULT_CSS_CLASS_NAME);
            }

            public static String hide(String markupId) {
                return "Wicket.Veil.toggle('" + markupId + "');";
            }
        }
    }
}

