/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.minis.apanel;

import java.util.List;
import org.apache.wicket.Component;
import org.wicketstuff.minis.apanel.IComponentRenderer;
import org.wicketstuff.minis.apanel.ILayout;
import org.wicketstuff.minis.apanel.RenderersList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlowLayout
implements ILayout {
    private static final long serialVersionUID = 1L;
    private final RenderersList renderersList;

    public FlowLayout() {
        this(RenderersList.getDefaultRenderers());
    }

    public FlowLayout(List<IComponentRenderer<?>> renderers) {
        this.renderersList = new RenderersList(renderers);
    }

    protected void onAfterTag(Component component, StringBuilder stringBuilder) {
    }

    protected void onBeforeTag(Component component, StringBuilder stringBuilder) {
    }

    @Override
    public CharSequence renderComponents(List<? extends Component> components) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Component component : components) {
            IComponentRenderer<Component> componentRenderer = this.renderersList.findRendererForClass(component.getClass());
            CharSequence markup = componentRenderer.getMarkup(component);
            this.onBeforeTag(component, stringBuilder);
            stringBuilder.append(markup);
            this.onAfterTag(component, stringBuilder);
        }
        return stringBuilder;
    }
}

