/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.minis.apanel;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.parser.XmlTag;
import org.wicketstuff.minis.apanel.GridLayoutConstraint;
import org.wicketstuff.minis.apanel.IComponentRenderer;
import org.wicketstuff.minis.apanel.ILayout;
import org.wicketstuff.minis.apanel.RenderersList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridLayout
implements ILayout {
    private static final long serialVersionUID = 1L;
    private static final Component EMPTY_CELL_COMPONENT = null;
    private final RenderersList renderersList;
    private final int width;
    private final int height;
    private final SortedMap<GridLayoutConstraint, Component> constraintsMap = new TreeMap<GridLayoutConstraint, Component>();

    private static XmlTag createXmlTag(String name, XmlTag.Type type) {
        XmlTag xmlTag = new XmlTag();
        xmlTag.setType(type);
        xmlTag.setName(name);
        return xmlTag;
    }

    public GridLayout(int width, int height) {
        this(width, height, RenderersList.getDefaultRenderers());
    }

    public GridLayout(int width, int height, List<IComponentRenderer<?>> renderers) {
        this.height = height;
        this.width = width;
        this.renderersList = new RenderersList(renderers);
    }

    private void checkConstraints(List<? extends Component> components) {
        for (int i = 0; i < components.size(); ++i) {
            GridLayoutConstraint constraint = this.getGridConstraint(components.get(i));
            if (constraint == null) continue;
            for (int j = i + 1; j < components.size(); ++j) {
                GridLayoutConstraint anotherConstraint = this.getGridConstraint(components.get(j));
                if (anotherConstraint == null || !constraint.intersectsWith(anotherConstraint)) continue;
                throw new WicketRuntimeException("Component " + components.get(i) + " and component " + components.get(j) + " has intersecting constraints");
            }
        }
    }

    private void fillConstraintsMap(List<? extends Component> components) {
        GridLayoutConstraint constraint;
        ArrayList<Component> componentsWithNoConstraint = new ArrayList<Component>();
        for (Component component : components) {
            constraint = this.getGridConstraint(component);
            if (constraint != null) {
                this.constraintsMap.put(constraint, component);
                continue;
            }
            componentsWithNoConstraint.add(component);
        }
        for (Component component : componentsWithNoConstraint) {
            constraint = this.findEmptyCellConstraint();
            if (constraint == null) {
                throw new WicketRuntimeException("There is no free cells in grid for the component " + component);
            }
            this.constraintsMap.put(constraint, component);
        }
        assert (this.constraintsMap.size() == components.size());
        GridLayoutConstraint constraint2 = this.findEmptyCellConstraint();
        while (constraint2 != null) {
            this.constraintsMap.put(constraint2, EMPTY_CELL_COMPONENT);
            constraint2 = this.findEmptyCellConstraint();
        }
    }

    private GridLayoutConstraint findEmptyCellConstraint() {
        for (int row = 0; row < this.height; ++row) {
            for (int col = 0; col < this.width; ++col) {
                if (this.isWithinAnyConstraint(col, row)) continue;
                return new GridLayoutConstraint(col, row);
            }
        }
        return null;
    }

    private GridLayoutConstraint getGridConstraint(Component component) {
        for (IBehavior behavior : component.getBehaviors()) {
            if (!(behavior instanceof GridLayoutConstraint)) continue;
            return (GridLayoutConstraint)behavior;
        }
        return null;
    }

    private boolean isWithinAnyConstraint(int col, int row) {
        for (GridLayoutConstraint constraint : this.constraintsMap.keySet()) {
            if (!constraint.contains(col, row)) continue;
            return true;
        }
        return false;
    }

    protected void onGridCell(Component component, XmlTag xmlTag) {
    }

    protected void onGridRow(XmlTag xmlTag) {
    }

    @Override
    public CharSequence renderComponents(List<? extends Component> components) {
        this.constraintsMap.clear();
        this.checkConstraints(components);
        this.fillConstraintsMap(components);
        StringBuilder stringBuilder = new StringBuilder();
        this.writeOutput(stringBuilder);
        return stringBuilder;
    }

    private void writeOutput(StringBuilder stringBuilder) {
        stringBuilder.append("<table>");
        GridConstraintIterator iterator = new GridConstraintIterator(this.constraintsMap.entrySet());
        while (iterator.hasNext()) {
            XmlTag xmlTag;
            Object entry = iterator.next();
            GridLayoutConstraint constraint = (GridLayoutConstraint)entry.getKey();
            Component component = (Component)entry.getValue();
            CharSequence markup = "";
            if (component != EMPTY_CELL_COMPONENT) {
                IComponentRenderer<Component> componentRenderer = this.renderersList.findRendererForClass(component.getClass());
                markup = componentRenderer.getMarkup(component);
            }
            if (iterator.isNewRow()) {
                stringBuilder.append("</tr>");
            }
            if (iterator.isNewRow() || iterator.isAtFirstConstraint()) {
                xmlTag = GridLayout.createXmlTag("tr", XmlTag.OPEN);
                this.onGridRow(xmlTag);
                stringBuilder.append(xmlTag.toCharSequence());
            }
            xmlTag = GridLayout.createXmlTag("td", XmlTag.OPEN);
            this.onGridCell(component, xmlTag);
            if (constraint.getColSpan() > 1) {
                xmlTag.put("colspan", constraint.getColSpan());
            }
            if (constraint.getRowSpan() > 1) {
                xmlTag.put("rowspan", constraint.getRowSpan());
            }
            stringBuilder.append(xmlTag.toCharSequence());
            stringBuilder.append(markup);
            stringBuilder.append("</td>");
        }
        stringBuilder.append("</tr>");
        stringBuilder.append("</table>");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GridConstraintIterator
    implements Iterator<Map.Entry<GridLayoutConstraint, Component>> {
        private final Iterator<Map.Entry<GridLayoutConstraint, Component>> iterator;
        private int currentRow = 0;
        private boolean isNewRow;
        private int currentIndex = 0;

        public GridConstraintIterator(Set<Map.Entry<GridLayoutConstraint, Component>> set) {
            this.iterator = set.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public boolean isAtFirstConstraint() {
            return this.currentIndex == 1;
        }

        public boolean isNewRow() {
            return this.isNewRow;
        }

        @Override
        public Map.Entry<GridLayoutConstraint, Component> next() {
            Map.Entry<GridLayoutConstraint, Component> entry = this.iterator.next();
            ++this.currentIndex;
            if (this.currentRow != entry.getKey().getRow()) {
                this.currentRow = entry.getKey().getRow();
                this.isNewRow = true;
            } else {
                this.isNewRow = false;
            }
            return entry;
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

