/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.minis.request.target.coding;

import java.util.Map;
import org.apache.wicket.IRequestTarget;
import org.apache.wicket.PageParameters;
import org.apache.wicket.application.IClassResolver;
import org.apache.wicket.protocol.http.request.WebRequestCodingStrategy;
import org.apache.wicket.request.RequestParameters;
import org.apache.wicket.request.target.coding.PackageRequestTargetUrlCodingStrategy;
import org.apache.wicket.request.target.component.BookmarkableListenerInterfaceRequestTarget;
import org.apache.wicket.request.target.component.BookmarkablePageRequestTarget;
import org.apache.wicket.util.lang.PackageName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.minis.request.target.coding.CaseInsensitiveClassResolver;

public class CaseInsensitivePackageRequestTargetUrlCodingStrategy
extends PackageRequestTargetUrlCodingStrategy {
    private static final Logger log = LoggerFactory.getLogger(CaseInsensitivePackageRequestTargetUrlCodingStrategy.class);
    private final PackageName packageName;
    private IClassResolver resolver = new CaseInsensitiveClassResolver();

    public CaseInsensitivePackageRequestTargetUrlCodingStrategy(String path, PackageName packageName) {
        super(path, packageName);
        this.packageName = packageName;
    }

    public IRequestTarget decode(RequestParameters requestParameters) {
        Class bookmarkablePageClass;
        String parametersFragment;
        String remainder = requestParameters.getPath().substring(this.getMountPath().length());
        int ix = remainder.indexOf(47, 1);
        if (ix == -1) {
            ix = remainder.length();
            parametersFragment = "";
        } else {
            parametersFragment = remainder.substring(ix);
        }
        if (!remainder.startsWith("/")) {
            return null;
        }
        remainder = remainder.substring(1);
        String bookmarkablePageClassName = this.packageName + "." + remainder.substring(0, --ix);
        try {
            bookmarkablePageClass = this.resolver.resolveClass(bookmarkablePageClassName);
        }
        catch (Exception e) {
            log.debug(e.getMessage());
            return null;
        }
        PageParameters parameters = new PageParameters((Map)this.decodeParameters(parametersFragment, requestParameters.getParameters()));
        String pageMapName = (String)parameters.remove((Object)"wicket:pageMapName");
        pageMapName = WebRequestCodingStrategy.decodePageMapName((String)pageMapName);
        requestParameters.setPageMapName(pageMapName);
        String interfaceParameter = (String)parameters.remove((Object)"wicket:interface");
        if (interfaceParameter != null) {
            WebRequestCodingStrategy.addInterfaceParameters((String)interfaceParameter, (RequestParameters)requestParameters);
            return new BookmarkableListenerInterfaceRequestTarget(pageMapName, bookmarkablePageClass, parameters, requestParameters.getComponentPath(), requestParameters.getInterfaceName(), requestParameters.getVersionNumber());
        }
        return new BookmarkablePageRequestTarget(pageMapName, bookmarkablePageClass, parameters);
    }
}

