/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.minis.util.collection;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import org.apache.wicket.model.IDetachable;
import org.wicketstuff.minis.util.IDetachCodec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDetachableCollection<T>
implements Collection<T>,
IDetachable,
Serializable {
    private static final long serialVersionUID = 1L;
    private final IDetachCodec<T> codec;
    private transient boolean attached = false;
    private Serializable[] detachedStore;
    private Collection<T> attachedStore;

    public AbstractDetachableCollection(IDetachCodec<T> codec) {
        if (codec == null) {
            throw new IllegalArgumentException("Argument `codec` cannot be null");
        }
        this.codec = codec;
    }

    public final void attach() {
        if (!this.attached) {
            this.attachedStore = this.newAttachedStore();
            if (this.detachedStore != null) {
                for (Serializable detached : this.detachedStore) {
                    T object = this.codec.attach(detached);
                    this.attachedStore.add(object);
                }
            }
            this.attached = true;
            this.detachedStore = null;
        }
    }

    public final void detach() {
        if (this.attached) {
            if (!this.attachedStore.isEmpty()) {
                this.detachedStore = new Serializable[this.attachedStore.size()];
                int idx = 0;
                for (T object : this.attachedStore) {
                    this.detachedStore[idx++] = this.codec.detach(object);
                }
            }
            this.attachedStore = null;
            this.attached = false;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof AbstractDetachableCollection) {
            AbstractDetachableCollection other = (AbstractDetachableCollection)obj;
            return ((Object)this.getAttachedStore()).equals(other.getAttachedStore());
        }
        if (obj instanceof Collection) {
            Collection other = (Collection)obj;
            return ((Object)other).equals(this.getAttachedStore());
        }
        return false;
    }

    protected Collection<T> getAttachedStore() {
        if (!this.attached) {
            this.attach();
        }
        return this.attachedStore;
    }

    @Override
    public int hashCode() {
        return ((Object)this.getAttachedStore()).hashCode();
    }

    protected abstract Collection<T> newAttachedStore();

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.attached) {
            throw new IllegalStateException("Detachable collection `" + this.getClass().getName() + "` is being serialized in its attached state. detach() must be invoked before any serialization attempt.");
        }
        out.defaultWriteObject();
    }
}

