/*
 * Decompiled with CFR 0.152.
 */
package wicket.contrib.phonebook;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.type.Type;
import wicket.contrib.phonebook.Contact;
import wicket.contrib.phonebook.ContactDao;
import wicket.contrib.phonebook.HibernateContactFinderQueryBuilder;
import wicket.contrib.phonebook.QueryParam;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateContactDao
implements ContactDao {
    private SessionFactory factory;

    public void setSessionFactory(SessionFactory factory) {
        this.factory = factory;
    }

    protected Session getSession() {
        return this.factory.getCurrentSession();
    }

    public Contact load(long id) {
        return (Contact)this.getSession().get(Contact.class, (Serializable)new Long(id));
    }

    public Contact save(Contact contact) {
        return (Contact)this.getSession().merge((Object)contact);
    }

    public void delete(long id) {
        this.getSession().delete((Object)this.load(id));
    }

    public Iterator<Contact> find(QueryParam qp, Contact filter) {
        return this.buildFindQuery(qp, filter, false).list().iterator();
    }

    public int count(Contact filter) {
        return ((Long)this.buildFindQuery(null, filter, true).uniqueResult()).intValue();
    }

    public List<String> getUniqueLastNames() {
        return this.getSession().createQuery("select distinct target.lastname  from Contact target order by target.lastname").list();
    }

    protected Query buildFindQuery(QueryParam qp, Contact filter, boolean count) {
        HibernateContactFinderQueryBuilder builder = new HibernateContactFinderQueryBuilder();
        builder.setQueryParam(qp);
        builder.setFilter(filter);
        builder.setCount(count);
        Query query = this.getSession().createQuery(builder.buildHql());
        query.setParameters((Object[])builder.getParameters(), (Type[])builder.getTypes());
        if (!count && qp != null) {
            query.setFirstResult(qp.getFirst()).setMaxResults(qp.getCount());
        }
        return query;
    }
}

