/*
 * Decompiled with CFR 0.152.
 */
package wicket.contrib.phonebook.web;

import java.util.Iterator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.filter.IFilterStateLocator;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.model.IModel;
import wicket.contrib.phonebook.Contact;
import wicket.contrib.phonebook.ContactDao;
import wicket.contrib.phonebook.QueryParam;
import wicket.contrib.phonebook.web.DetachableContactModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContactsDataProvider
extends SortableDataProvider<Contact>
implements IFilterStateLocator {
    private final ContactDao dao;
    private Contact filter = new Contact();
    private QueryParam queryParam;

    public void setQueryParam(QueryParam queryParam) {
        this.queryParam = queryParam;
    }

    public Object getFilterState() {
        return this.filter;
    }

    public void setFilterState(Object state) {
        this.filter = (Contact)state;
    }

    public ContactsDataProvider(ContactDao dao) {
        this.dao = dao;
        this.setSort("firstname", true);
    }

    public Iterator<Contact> iterator(int first, int count) {
        SortParam sp = this.getSort();
        if (this.queryParam == null) {
            this.queryParam = new QueryParam(first, count, sp.getProperty(), sp.isAscending());
        } else {
            this.queryParam.setFirst(first);
            this.queryParam.setCount(count);
            this.queryParam.setSort(sp.getProperty());
            this.queryParam.setSortAsc(sp.isAscending());
        }
        return this.dao.find(this.queryParam, this.filter);
    }

    public int size() {
        return this.dao.count(this.filter);
    }

    public IModel<Contact> model(Contact object) {
        return new DetachableContactModel(object, this.dao);
    }
}

