/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.eidogo;

import org.apache.wicket.ResourceReference;
import org.apache.wicket.Response;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.WebComponent;
import org.apache.wicket.markup.html.resources.JavascriptResourceReference;
import org.apache.wicket.markup.parser.XmlTag;
import org.apache.wicket.util.string.JavascriptUtils;

public class Eidogo
extends WebComponent
implements IHeaderContributor {
    private static final long serialVersionUID = 1L;
    private static final ResourceReference JS = new JavascriptResourceReference(Eidogo.class, "js/all.compressed.js");
    private static final ResourceReference CSS = new ResourceReference(Eidogo.class, "css/player.css");
    private boolean showComments;
    private boolean showPlayerInfo;
    private boolean showGameInfo;
    private boolean showTools;
    private boolean showOptions;
    private boolean markCurrent;
    private boolean markVariation;
    private boolean markNext;
    private boolean enableShortcuts;
    private boolean problemMode;
    private Theme theme = Theme.STANDARD;
    private Mode mode = Mode.PLAY;
    private String sgfUrl;

    public Eidogo(String id) {
        this(id, null);
    }

    public Eidogo(String id, String sgfUrl) {
        super(id);
        this.sgfUrl = sgfUrl;
    }

    public void renderHead(IHeaderResponse response) {
        response.renderJavascriptReference(JS);
        response.renderCSSReference(CSS);
    }

    protected void onComponentTag(ComponentTag tag) {
        this.checkComponentTag(tag, "div");
        this.setOutputMarkupId(true);
        if (tag.isOpenClose()) {
            tag.setType(XmlTag.OPEN);
        }
        super.onComponentTag(tag);
    }

    public void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        super.onComponentTagBody(markupStream, openTag);
        this.replaceComponentTagBody(markupStream, openTag, null);
        JavascriptUtils.writeJavascript((Response)this.getResponse(), (CharSequence)("new eidogo.Player({container:\"" + this.getMarkupId() + "\",theme:\"" + (Object)((Object)this.theme) + "\"," + "sgfUrl:\"" + this.getResponse().encodeURL((CharSequence)this.sgfUrl) + "\"," + "loadPath:[0, 0]" + ",mode:\"" + (Object)((Object)this.mode) + "\"," + "showComments:" + this.showComments + "," + "showPlayerInfo:" + this.showPlayerInfo + "," + "showGameInfo:" + this.showGameInfo + "," + "showTools:" + this.showTools + "," + "showOptions:" + this.showOptions + "," + "markCurrent:" + this.markCurrent + "," + "markVariations:" + this.markVariation + "," + "markNext:" + this.markNext + "," + "enableShortcuts:" + this.enableShortcuts + "," + "problemMode:" + this.problemMode + "});"));
    }

    public boolean isShowComments() {
        return this.showComments;
    }

    public void setShowComments(boolean showComments) {
        this.showComments = showComments;
    }

    public boolean isShowPlayerInfo() {
        return this.showPlayerInfo;
    }

    public void setShowPlayerInfo(boolean showPlayerInfo) {
        this.showPlayerInfo = showPlayerInfo;
    }

    public boolean isShowGameInfo() {
        return this.showGameInfo;
    }

    public void setShowGameInfo(boolean showGameInfo) {
        this.showGameInfo = showGameInfo;
    }

    public boolean isShowTools() {
        return this.showTools;
    }

    public void setShowTools(boolean showTools) {
        this.showTools = showTools;
    }

    public boolean isShowOtions() {
        return this.showOptions;
    }

    public void setShowOtions(boolean showOtions) {
        this.showOptions = showOtions;
    }

    public boolean isMarkCurrent() {
        return this.markCurrent;
    }

    public void setMarkCurrent(boolean markCurrent) {
        this.markCurrent = markCurrent;
    }

    public boolean isMarkVariation() {
        return this.markVariation;
    }

    public void setMarkVariation(boolean markVariation) {
        this.markVariation = markVariation;
    }

    public boolean isMarkNext() {
        return this.markNext;
    }

    public void setMarkNext(boolean markNext) {
        this.markNext = markNext;
    }

    public boolean isEnableShortcuts() {
        return this.enableShortcuts;
    }

    public void setEnableShortcuts(boolean enableShortcuts) {
        this.enableShortcuts = enableShortcuts;
    }

    public boolean isProblemMode() {
        return this.problemMode;
    }

    public void setProblemMode(boolean problemMode) {
        this.problemMode = problemMode;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        PLAY("play"),
        ADD_BLACK("add_b"),
        ADD_WHITE("add_w"),
        REGION("region"),
        TRIANGLE("tr"),
        SQUARE("sq"),
        CIRCLE("cr"),
        LABEL("label"),
        NUMBER("number"),
        SCORE("score");

        private String value;

        private Mode(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Theme {
        STANDARD("standard");

        private String value;

        private Theme(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

