/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.facebook.plugins;

import java.io.Serializable;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.util.iterator.ComponentHierarchyIterator;
import org.wicketstuff.facebook.FacebookRootProvider;
import org.wicketstuff.facebook.MissingFacebookRootException;
import org.wicketstuff.facebook.plugins.ColorScheme;
import org.wicketstuff.facebook.plugins.Font;

public abstract class AbstractFacebookPlugin
extends WebMarkupContainer {
    private static final long serialVersionUID = 1L;
    private ColorScheme colorScheme;
    private Font font;

    protected AbstractFacebookPlugin(String id, String facebookPluginClass) {
        super(id);
        this.add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)facebookPluginClass))});
        this.add(new Behavior[]{new AttributeModifier("data-colorscheme", (IModel)new EnumModel((IModel<? extends Enum<?>>)new PropertyModel((Object)this, "colorScheme")))});
        this.add(new Behavior[]{new AttributeModifier("data-font", (IModel)new EnumModel((IModel<? extends Enum<?>>)new PropertyModel((Object)this, "font")))});
    }

    public ColorScheme getColorScheme() {
        return this.colorScheme;
    }

    public Font getFont() {
        return this.font;
    }

    public void setColorScheme(ColorScheme colorScheme) {
        this.colorScheme = colorScheme;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    protected void onRender() {
        AjaxRequestTarget target;
        ComponentHierarchyIterator visitChildren = this.getPage().visitChildren(FacebookRootProvider.class);
        if (!visitChildren.hasNext()) {
            throw new MissingFacebookRootException();
        }
        if (this.findPage() != null && (target = (AjaxRequestTarget)this.getRequestCycle().find(AjaxRequestTarget.class)) != null) {
            this.setOutputMarkupId(true);
            StringBuilder js = new StringBuilder();
            js.append("FB.XFBML.parse(document.getElementById('");
            js.append(this.getMarkupId());
            js.append("').parentNode);");
            target.appendJavaScript((CharSequence)js.toString());
        }
        super.onRender();
    }

    protected class EnumModel
    extends AbstractReadOnlyModel<String> {
        private static final long serialVersionUID = 1L;
        private final IModel<? extends Enum<?>> model;

        public EnumModel(IModel<? extends Enum<?>> model) {
            this.model = model;
        }

        public void detach() {
            this.model.detach();
        }

        public String getObject() {
            if (this.model == null || this.model.getObject() == null) {
                return null;
            }
            return ((Enum)this.model.getObject()).name().toLowerCase();
        }
    }
}

