/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.facebook.plugins;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.wicketstuff.facebook.FacebookPermission;
import org.wicketstuff.facebook.plugins.AbstractFacebookPlugin;

public class LoginButton
extends AbstractFacebookPlugin {
    private static final long serialVersionUID = 1L;
    private int maxRows = 1;
    private List<FacebookPermission> permissions = Collections.emptyList();
    private boolean showFaces = false;

    public LoginButton(String id) {
        super(id, "fb-login-button");
        this.add(new Behavior[]{new AttributeModifier("data-show-faces", (IModel)new PropertyModel((Object)this, "showFaces"))});
        this.add(new Behavior[]{new AttributeModifier("data-max-rows", (IModel)new PropertyModel((Object)this, "maxRows"))});
        this.add(new Behavior[]{new AttributeModifier("data-scope", (IModel)new PermissionsModel())});
    }

    public LoginButton(String id, FacebookPermission ... permissions) {
        this(id);
        this.permissions = Arrays.asList(permissions);
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public List<FacebookPermission> getPermissions() {
        return this.permissions;
    }

    public boolean isShowFaces() {
        return this.showFaces;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    public void setPermissions(List<FacebookPermission> permissions) {
        this.permissions = permissions;
    }

    public void setShowFaces(boolean showFaces) {
        this.showFaces = showFaces;
    }

    private class PermissionsModel
    extends AbstractReadOnlyModel<String> {
        private static final long serialVersionUID = 1L;

        private PermissionsModel() {
        }

        public String getObject() {
            StringBuilder str = new StringBuilder();
            for (FacebookPermission perm : LoginButton.this.permissions) {
                str.append(perm.name().toLowerCase()).append(',');
            }
            if (str.length() > 0) {
                str.deleteCharAt(str.length() - 1);
            }
            return str.toString();
        }
    }
}

