/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.facebook;

import java.util.HashMap;
import java.util.Map;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.head.StringHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.wicketstuff.facebook.FacebookRootProvider;

public class FacebookSdk
extends WebMarkupContainer
implements FacebookRootProvider {
    private final String appId;
    private final Map<String, String> metaParams = new HashMap<String, String>();

    public FacebookSdk(String id) {
        this(id, null);
    }

    public FacebookSdk(String id, String appId) {
        super(id);
        this.appId = appId;
        this.metaParams.put("fb:app_id", appId);
    }

    public String getMarkupId() {
        return "fb-root";
    }

    public boolean isVisible() {
        return true;
    }

    public void renderHead(IHeaderResponse response) {
        response.render((HeaderItem)JavaScriptHeaderItem.forUrl((String)"//connect.facebook.net/en_US/all.js"));
        StringBuilder js = new StringBuilder();
        js.append("FB.init({");
        if (this.appId != null) {
            js.append("appId  : '").append(this.appId).append("',");
        }
        js.append("status : true,");
        js.append("cookie : true,");
        js.append("xfbml  : true");
        js.append("});");
        response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)js));
        for (Map.Entry<String, String> entry : this.metaParams.entrySet()) {
            StringBuilder sb = new StringBuilder();
            sb.append("<meta property=\"").append(entry.getKey()).append("\" ");
            sb.append("content=\"").append(entry.getValue()).append("\" />");
            sb.append('\n');
            response.render((HeaderItem)StringHeaderItem.forString((CharSequence)sb));
        }
    }

    public void setFbAdmins(String ... userId) {
        StringBuilder admins = new StringBuilder();
        for (String id : userId) {
            admins.append(id).append(',');
        }
        if (admins.length() > 0) {
            admins.deleteCharAt(admins.length() - 1);
        }
        this.metaParams.put("fb:admins", admins.toString());
    }

    public void setOgProperty(String property, String value) {
        StringBuilder sb = new StringBuilder(property.length() + 3);
        sb.append("og:").append(property);
        this.metaParams.put(sb.toString(), value);
    }
}

