/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.facebook.behaviors;

import java.util.Arrays;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.request.IRequestParameters;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.cycle.RequestCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.facebook.FacebookRootProvider;
import org.wicketstuff.facebook.MissingFacebookRootException;

public abstract class AbstractSubscribeBehavior
extends AbstractDefaultAjaxBehavior {
    private static final Logger log = LoggerFactory.getLogger(AbstractSubscribeBehavior.class);
    private final String event;
    private final List<String> parameters;

    protected AbstractSubscribeBehavior(String event, String ... parameters) {
        this.event = event;
        this.parameters = Arrays.asList(parameters);
    }

    private void checkFacebookRoot(Component component) {
        Boolean found = (Boolean)component.getPage().visitChildren(FacebookRootProvider.class, (object, visit) -> visit.stop((Object)true));
        if (found == null) {
            throw new MissingFacebookRootException();
        }
    }

    protected abstract void onEvent(AjaxRequestTarget var1, IRequestParameters var2, String var3);

    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        this.checkFacebookRoot(component);
        StringBuilder js = new StringBuilder();
        js.append("FB.Event.subscribe('").append(this.event).append("', function(response) { ");
        js.append("var callback = '").append(this.getCallbackUrl()).append("'; ");
        for (String param : this.parameters) {
            js.append("try{ callback += '&").append(param).append("='+").append("Wicket.Form.encode(response.").append(param).append(");}catch(e){};");
        }
        js.append("Wicket.Ajax.get({'u':callback+'&response='+Wicket.Form.encode(response)});");
        js.append('}');
        js.append(");");
        response.render((HeaderItem)JavaScriptHeaderItem.forScript((CharSequence)js.toString(), null));
    }

    protected void respond(AjaxRequestTarget target) {
        Request request = RequestCycle.get().getRequest();
        IRequestParameters requestParameters = request.getRequestParameters();
        if (log.isDebugEnabled()) {
            log.debug("onRequest - response:" + requestParameters.getParameterValue("response").toString());
        }
        this.onEvent(target, requestParameters, requestParameters.getParameterValue("response").toOptionalString());
    }
}

