/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.facebook.plugins;

import java.io.Serializable;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.wicketstuff.facebook.plugins.AbstractFacebookPlugin;

public class LikeButton
extends AbstractFacebookPlugin {
    private static final long serialVersionUID = 1L;
    private LikeButtonAction action;
    private LikeButtonLayoutStyle layoutStyle;
    private boolean sendButton = true;
    private boolean showFaces = true;
    private final IModel<?> url;

    public LikeButton(String id) {
        this(id, (IModel<?>)Model.of());
    }

    public LikeButton(String id, IModel<?> url) {
        super(id, "fb-like");
        this.url = url;
        this.initPlugin();
    }

    public LikeButton(String id, String url) {
        this(id, (IModel<?>)Model.of((Serializable)((Object)url)));
    }

    public LikeButtonAction getAction() {
        return this.action;
    }

    public LikeButtonLayoutStyle getLayoutStyle() {
        return this.layoutStyle;
    }

    public boolean isSendButton() {
        return this.sendButton;
    }

    public boolean isShowFaces() {
        return this.showFaces;
    }

    public void setAction(LikeButtonAction displayVerb) {
        this.action = displayVerb;
    }

    public void setLayoutStyle(LikeButtonLayoutStyle layoutStyle) {
        this.layoutStyle = layoutStyle;
    }

    public void setSendButton(boolean sendButton) {
        this.sendButton = sendButton;
    }

    public void setShowFaces(boolean showFaces) {
        this.showFaces = showFaces;
    }

    private void initPlugin() {
        this.add(new Behavior[]{new AttributeModifier("data-href", this.url)});
        this.add(new Behavior[]{new AttributeModifier("data-send", (IModel)new PropertyModel((Object)this, "sendButton"))});
        this.add(new Behavior[]{new AttributeModifier("data-layout", (IModel)new AbstractFacebookPlugin.EnumModel(this, (IModel<? extends Enum<?>>)new PropertyModel((Object)this, "layoutStyle")))});
        this.add(new Behavior[]{new AttributeModifier("data-action", (IModel)new AbstractFacebookPlugin.EnumModel(this, (IModel<? extends Enum<?>>)new PropertyModel((Object)this, "action")))});
        this.add(new Behavior[]{new AttributeModifier("data-show-faces", (IModel)new PropertyModel((Object)this, "showFaces"))});
    }

    public static enum LikeButtonLayoutStyle {
        BOX_COUNT,
        BUTTON_COUNT,
        STANDARD;

    }

    public static enum LikeButtonAction {
        LIKE,
        RECOMMEND;

    }
}

