/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.ki.component;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.util.value.ValueMap;
import org.jsecurity.SecurityUtils;
import org.jsecurity.authc.AuthenticationException;
import org.jsecurity.authc.AuthenticationToken;
import org.jsecurity.authc.IncorrectCredentialsException;
import org.jsecurity.authc.UnknownAccountException;
import org.jsecurity.authc.UsernamePasswordToken;
import org.jsecurity.subject.Subject;

public class LoginPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    private boolean includeRememberMe = true;
    private PasswordTextField password;
    private boolean rememberMe = true;
    private TextField<String> username;

    public LoginPanel(String id) {
        this(id, true);
    }

    public LoginPanel(String id, boolean includeRememberMe) {
        super(id);
        this.includeRememberMe = includeRememberMe;
        if (!includeRememberMe) {
            this.rememberMe = false;
        }
        this.add(new Component[]{new FeedbackPanel("feedback")});
        this.add(new Component[]{new SignInForm("signInForm")});
    }

    public String getPassword() {
        return this.password.getInput();
    }

    public boolean getRememberMe() {
        return this.rememberMe;
    }

    public String getUsername() {
        return this.username.getDefaultModelObjectAsString();
    }

    public void setRememberMe(boolean rememberMe) {
        this.rememberMe = rememberMe;
    }

    public boolean login(String username, String password, boolean rememberMe) {
        Subject currentUser = SecurityUtils.getSubject();
        UsernamePasswordToken token = new UsernamePasswordToken(username, password, rememberMe);
        try {
            currentUser.login((AuthenticationToken)token);
            return true;
        }
        catch (IncorrectCredentialsException ice) {
            this.error((Serializable)((Object)"Password is incorrect."));
        }
        catch (UnknownAccountException uae) {
            this.error((Serializable)((Object)"There is no account with that username."));
        }
        catch (AuthenticationException ae) {
            this.error((Serializable)((Object)"Invalid username and/or password."));
        }
        catch (Exception ex) {
            this.error((Serializable)((Object)"Login failed"));
        }
        return false;
    }

    protected void onSignInSucceeded() {
        if (!this.continueToOriginalDestination()) {
            this.setResponsePage(this.getApplication().getSessionSettings().getPageFactory().newPage(this.getApplication().getHomePage()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class SignInForm
    extends Form<Void> {
        private static final long serialVersionUID = 1L;
        private final ValueMap properties;

        public SignInForm(String id) {
            super(id);
            this.properties = new ValueMap();
            this.add(new Component[]{LoginPanel.this.username = new TextField("username", (IModel)new PropertyModel((Object)this.properties, "username"))});
            this.add(new Component[]{LoginPanel.this.password = new PasswordTextField("password", (IModel)new PropertyModel((Object)this.properties, "password"))});
            WebMarkupContainer rememberMeRow = new WebMarkupContainer("rememberMeRow");
            this.add(new Component[]{rememberMeRow});
            rememberMeRow.add(new Component[]{new CheckBox("rememberMe", (IModel)new PropertyModel((Object)LoginPanel.this, "rememberMe"))});
            rememberMeRow.setVisible(LoginPanel.this.includeRememberMe);
        }

        public final void onSubmit() {
            if (LoginPanel.this.login(LoginPanel.this.getUsername(), LoginPanel.this.getPassword(), LoginPanel.this.getRememberMe())) {
                LoginPanel.this.onSignInSucceeded();
            }
        }
    }
}

