/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.ki.annotation;

import java.lang.annotation.Annotation;
import org.apache.wicket.Component;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authorization.IAuthorizationStrategy;
import org.jsecurity.SecurityUtils;
import org.jsecurity.mgt.SecurityManager;
import org.jsecurity.subject.Subject;
import org.jsecurity.util.ThreadContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.ki.KiAction;
import org.wicketstuff.ki.annotation.KiSecurityConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationsKiAuthorizationStrategy
implements IAuthorizationStrategy {
    static final Logger log = LoggerFactory.getLogger(AnnotationsKiAuthorizationStrategy.class);

    public <T extends Component> boolean isInstantiationAuthorized(Class<T> componentClass) {
        KiSecurityConstraint fail = this.checkInvalidInstantiation(componentClass);
        if (fail != null) {
            log.info("Unuthorized Instantiation :: component={} reason={} subject={}", new Object[]{componentClass, fail, SecurityUtils.getSubject()});
            return false;
        }
        return true;
    }

    public <T extends Component> KiSecurityConstraint checkInvalidInstantiation(Class<T> componentClass) {
        KiSecurityConstraint fail = this.checkInvalidInstantiation(componentClass.getAnnotations(), KiAction.INSTANTIATE);
        if (fail == null) {
            fail = this.checkInvalidInstantiation(componentClass.getPackage().getAnnotations(), KiAction.INSTANTIATE);
        }
        return fail;
    }

    protected KiSecurityConstraint checkInvalidInstantiation(Annotation[] annotations, KiAction action) {
        if (annotations == null) {
            return null;
        }
        block6: for (Annotation annotation : annotations) {
            KiSecurityConstraint constraint;
            if (!(annotation instanceof KiSecurityConstraint) || action != (constraint = (KiSecurityConstraint)annotation).action()) continue;
            SecurityManager sm = ThreadContext.getSecurityManager();
            Subject subject = SecurityUtils.getSubject();
            switch (constraint.constraint()) {
                case HasRole: {
                    if (sm.hasRole(subject.getPrincipals(), constraint.value())) continue block6;
                    return constraint;
                }
                case HasPermission: {
                    if (sm.isPermitted(subject.getPrincipals(), constraint.value())) continue block6;
                    return constraint;
                }
                case IsAuthenticated: {
                    if (subject.isAuthenticated()) continue block6;
                    return constraint;
                }
                case LoggedIn: {
                    if (subject.getPrincipal() != null) continue block6;
                    return constraint;
                }
            }
        }
        return null;
    }

    public boolean isActionAuthorized(Component component, Action action) {
        KiAction _action = action.getName().equals("RENDER") ? KiAction.RENDER : KiAction.ENABLE;
        Class<?> clazz = component.getClass();
        KiSecurityConstraint fail = this.checkInvalidInstantiation(clazz.getAnnotations(), _action);
        if (fail == null) {
            fail = this.checkInvalidInstantiation(clazz.getPackage().getAnnotations(), _action);
        }
        return fail == null;
    }
}

