/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.ki.authz;

import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.RestartResponseAtInterceptPageException;
import org.apache.wicket.RestartResponseException;
import org.apache.wicket.Session;
import org.apache.wicket.authorization.IUnauthorizedComponentInstantiationListener;
import org.jsecurity.SecurityUtils;
import org.jsecurity.subject.Subject;
import org.wicketstuff.ki.annotation.AnnotationsKiAuthorizationStrategy;
import org.wicketstuff.ki.annotation.KiSecurityConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KiUnauthorizedComponentListener
implements IUnauthorizedComponentInstantiationListener {
    private final Class<? extends Page> loginPage;
    private final Class<? extends Page> unauthorizedPage;
    private AnnotationsKiAuthorizationStrategy annotationStrategy = null;

    public KiUnauthorizedComponentListener(Class<? extends Page> loginPage, Class<? extends Page> unauthorizedPage, AnnotationsKiAuthorizationStrategy s) {
        this.loginPage = loginPage;
        this.unauthorizedPage = unauthorizedPage;
        this.annotationStrategy = s;
    }

    public void onUnauthorizedInstantiation(Component component) {
        KiSecurityConstraint fail;
        Class<? extends Page> page;
        Subject subject = SecurityUtils.getSubject();
        boolean notLoggedIn = subject.getPrincipal() == null;
        Class<? extends Page> clazz = page = notLoggedIn ? this.loginPage : this.unauthorizedPage;
        if (this.annotationStrategy != null && (fail = this.annotationStrategy.checkInvalidInstantiation(component.getClass())) != null) {
            if (notLoggedIn) {
                this.addLoginMessagesAndGetPage(fail, component, page);
            } else {
                this.addUnauthorizedMessagesAndGetPage(fail, component, page);
            }
        }
        if (notLoggedIn) {
            throw new RestartResponseAtInterceptPageException(page);
        }
        throw new RestartResponseException(page);
    }

    public AnnotationsKiAuthorizationStrategy getAnnotationStrategy() {
        return this.annotationStrategy;
    }

    public void setAnnotationStrategy(AnnotationsKiAuthorizationStrategy annotationStrategy) {
        this.annotationStrategy = annotationStrategy;
    }

    protected Class<? extends Page> addUnauthorizedMessagesAndGetPage(KiSecurityConstraint constraint, Component component, Class<? extends Page> page) {
        if (constraint.unauthorizedMessage().length() > 0) {
            Session.get().info(this.getMessage(constraint.unauthorizedMessage(), constraint, component));
        }
        if (constraint.unauthorizedPage() != Page.class) {
            page = constraint.unauthorizedPage();
        }
        return page;
    }

    protected Class<? extends Page> addLoginMessagesAndGetPage(KiSecurityConstraint constraint, Component component, Class<? extends Page> page) {
        if (constraint.loginMessage().length() > 0) {
            Session.get().info(this.getMessage(constraint.loginMessage(), constraint, component));
        }
        if (constraint.loginPage() != Page.class) {
            page = constraint.loginPage();
        }
        return page;
    }

    protected String getMessage(String key, KiSecurityConstraint anno, Component comp) {
        return key;
    }
}

