/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.ki.page;

import java.io.Serializable;
import javax.servlet.http.Cookie;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.PageParameters;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.Session;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.protocol.http.WebResponse;
import org.jsecurity.SecurityUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogoutPage
extends WebPage {
    public static final String REDIRECTPAGE_PARAM = "redirectpage";

    public LogoutPage(CharSequence url) {
        this.doLogoutAndAddRedirect(url, this.getDelayTime());
    }

    public LogoutPage(PageParameters parameters) {
        Class pageClass;
        String page = parameters.getString(REDIRECTPAGE_PARAM);
        if (page != null) {
            try {
                pageClass = Class.forName(page);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        } else {
            pageClass = this.getApplication().getHomePage();
        }
        this.setStatelessHint(true);
        this.setResponsePage(pageClass);
        SecurityUtils.getSubject().logout();
        Session.get().invalidateNow();
    }

    public LogoutPage(Class<? extends Page> pageClass) {
        this.doLogoutAndAddRedirect(this.urlFor(pageClass, null), this.getDelayTime());
    }

    private void doLogoutAndAddRedirect(CharSequence url, int waitBeforeRedirectInSeconds) {
        this.setStatelessHint(true);
        SecurityUtils.getSubject().logout();
        WebMarkupContainer redirect = new WebMarkupContainer("redirect");
        String content = waitBeforeRedirectInSeconds + ";URL=" + url;
        redirect.add(new IBehavior[]{new AttributeModifier("content", (IModel)new Model((Serializable)((Object)content)))});
        this.add(new Component[]{redirect});
        Session.get().invalidateNow();
        Cookie c = new Cookie("rememberMe", "xxx");
        c.setMaxAge(0);
        ((WebResponse)RequestCycle.get().getResponse()).addCookie(c);
    }

    public boolean isVersioned() {
        return false;
    }

    public int getDelayTime() {
        return 0;
    }
}

