/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.ki.wicket.page.store;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.wicket.Page;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.protocol.http.pagestore.AbstractPageStore;
import org.jsecurity.SecurityUtils;
import org.jsecurity.session.Session;
import org.jsecurity.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.ki.wicket.page.store.PageCacheManager;
import org.wicketstuff.ki.wicket.page.store.SerializedPageWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionPageStore
extends AbstractPageStore {
    private static final Logger log = LoggerFactory.getLogger(SessionPageStore.class);
    private static final String PAGE_MAP_SESSION_KEY = SessionPageStore.class.getName() + "_PAGE_CACHE_MANAGER_SESSION_KEY";
    protected static final int DEFAULT_MAX_PAGES = -1;
    private final int MAX_PAGE_MAP_SIZE;

    public SessionPageStore() {
        this.MAX_PAGE_MAP_SIZE = -1;
        log.info("Created SessionPageStore: unlimited number of pages allowed.");
    }

    public SessionPageStore(int maxPageMapSize) {
        if (maxPageMapSize < -1) {
            this.MAX_PAGE_MAP_SIZE = -1;
            log.info("Created SessionPageStore: unlimited number of pages allowed.");
        } else {
            this.MAX_PAGE_MAP_SIZE = maxPageMapSize;
            log.info("Created SessionPageStore: [{}] maximum number of pages allowed.", (Object)maxPageMapSize);
        }
    }

    public int getMaxPageMapSize() {
        return this.MAX_PAGE_MAP_SIZE;
    }

    protected Session getSessionForUpdate(String sessionId) {
        Session session = this.getSession(sessionId);
        if (session == null) {
            session = SecurityUtils.getSubject().getSession();
        }
        return session;
    }

    protected Session getSession(String sessionId) {
        Session session = null;
        Subject currentSubject = SecurityUtils.getSubject();
        if (currentSubject != null && (session = currentSubject.getSession(false)) != null && sessionId != null && !sessionId.equals(session.getId())) {
            String msg = "The specified Wicket sessionId [" + sessionId + "] is not the same as JSecurity's " + "current Subject Session with id [" + session.getId() + "], indicating the Wicket request's " + "session is not the same as JSecurity's current Subject Session.  The two must always be " + "equal when using the " + ((Object)((Object)this)).getClass().getName() + " implementation.  If you're seeing this " + "exception, ensure you have configured JSecurity to use Enterprise Sessions and not " + "(the default) HTTP-only Sessions.";
            throw new WicketRuntimeException(msg);
        }
        return session;
    }

    public void destroy() {
    }

    public <T> Page getPage(String sessionId, String pageMapName, int id, int versionNumber, int ajaxVersionNumber) {
        SerializedPageWrapper wrapper = this.getPageCacheManager(sessionId).getPageCache(pageMapName).getPage(id, versionNumber, ajaxVersionNumber);
        AbstractPageStore.SerializedPage sPage = wrapper != null ? (AbstractPageStore.SerializedPage)wrapper.getPage() : null;
        return sPage != null ? this.deserializePage(sPage.getData(), versionNumber) : null;
    }

    public void pageAccessed(String sessionId, Page page) {
    }

    public void removePage(String sessionId, String pageMapName, int id) {
        if (id == -1) {
            log.debug("Removing page map [{}]", (Object)pageMapName);
            this.getPageCacheManager(sessionId).removePageCache(pageMapName);
        } else {
            log.debug("Removing page with id [{}] from page map [{}]", (Object)id, (Object)pageMapName);
            this.getPageCacheManager(sessionId).getPageCache(pageMapName).removePage(id);
        }
    }

    protected PageCacheManager getPageCacheManager(String sessionId) {
        Session session = this.getSessionForUpdate(sessionId);
        PageCacheManager pcc = (PageCacheManager)session.getAttribute((Object)PAGE_MAP_SESSION_KEY);
        if (pcc == null) {
            pcc = new PageCacheManager(this.getMaxPageMapSize());
            session.setAttribute((Object)PAGE_MAP_SESSION_KEY, (Object)pcc);
        }
        return pcc;
    }

    Collection<SerializedPageWrapper> wrap(Collection<AbstractPageStore.SerializedPage> serializedPages) {
        ArrayList<SerializedPageWrapper> wrappers = new ArrayList<SerializedPageWrapper>(serializedPages.size());
        for (AbstractPageStore.SerializedPage sPage : serializedPages) {
            SerializedPageWrapper wrapper = new SerializedPageWrapper((Serializable)sPage, sPage.getPageId(), sPage.getPageMapName(), sPage.getVersionNumber(), sPage.getAjaxVersionNumber());
            wrappers.add(wrapper);
        }
        return wrappers;
    }

    protected Collection<SerializedPageWrapper> serialize(Page page) {
        List serializedPages = this.serializePage(page);
        return this.wrap(serializedPages);
    }

    public void storePage(String sessionId, Page page) {
        Collection<SerializedPageWrapper> wrapped = this.serialize(page);
        this.getPageCacheManager(sessionId).getPageCache(page.getPageMapName()).storePages(wrapped);
        if (log.isDebugEnabled()) {
            log.debug("storePage {}", (Object)page.toString());
            log.debug(this.getPageCacheManager(sessionId).getPageCache(page.getPageMapName()).toString());
        }
    }

    public void unbind(String sessionId) {
        Object existing;
        Session active = this.getSession(sessionId);
        if (active != null && (existing = active.removeAttribute((Object)PAGE_MAP_SESSION_KEY)) != null) {
            log.debug("Removed PageMap [{}] from the Session (destroying)", existing);
        }
    }

    public boolean containsPage(String sessionId, String pageMapName, int pageId, int pageVersion) {
        return this.getPageCacheManager(sessionId).getPageCache(pageMapName).containsPage(pageId, pageVersion);
    }
}

