/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.ki.wicket.page.store;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.wicket.IClusterable;
import org.wicketstuff.ki.wicket.page.store.PageCache;

public class PageCacheManager
implements IClusterable {
    private static final long serialVersionUID = 1L;
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final Lock read = this.rwl.readLock();
    private final Lock write = this.rwl.writeLock();
    private final Map<String, PageCache> caches = new HashMap<String, PageCache>();
    private final int MAX_PAGES_PER_MAP;

    public PageCacheManager(int maxNumPagesPerMap) {
        this.MAX_PAGES_PER_MAP = maxNumPagesPerMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PageCache getPageCache(String name) {
        PageCache toReturn;
        this.read.lock();
        try {
            toReturn = this.caches.get(name);
        }
        finally {
            this.read.unlock();
        }
        if (toReturn == null) {
            this.write.lock();
            try {
                toReturn = new PageCache(this.MAX_PAGES_PER_MAP);
                PageCache old = this.caches.put(name, toReturn);
                if (old != null) {
                    toReturn = old;
                    this.caches.put(name, toReturn);
                }
            }
            finally {
                this.write.unlock();
            }
        }
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePageCache(String name) {
        this.write.lock();
        try {
            this.caches.remove(name);
        }
        finally {
            this.write.unlock();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, PageCache> entry : this.caches.entrySet()) {
            sb.append("PageCache: ").append(entry.getKey()).append("\n");
            sb.append(entry.getValue().toString());
        }
        return sb.toString();
    }
}

