/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.ki.wicket.page.store;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.wicket.IClusterable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.ki.wicket.page.store.PageKey;
import org.wicketstuff.ki.wicket.page.store.SerializedPageWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageCache
implements IClusterable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(PageCache.class);
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final Lock read = this.rwl.readLock();
    private final Lock write = this.rwl.writeLock();
    private final LinkedHashMap<PageKey, SerializedPageWrapper> pages = new LinkedHashMap();
    private final TreeMap<PageKey, Integer> pageKeys = new TreeMap();
    private final AtomicInteger id = new AtomicInteger(Integer.MIN_VALUE);
    private final int MAX_SIZE;

    public PageCache(int maxSize) {
        this.MAX_SIZE = maxSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storePages(Collection<SerializedPageWrapper> pagesToAdd) {
        this.write.lock();
        try {
            int numToRemove;
            if (this.MAX_SIZE != -1 && (numToRemove = this.pages.size() + pagesToAdd.size() - this.MAX_SIZE) > 0) {
                Iterator<Map.Entry<PageKey, SerializedPageWrapper>> iter = this.pages.entrySet().iterator();
                while (iter.hasNext() && numToRemove > 0) {
                    Map.Entry<PageKey, SerializedPageWrapper> entry = iter.next();
                    iter.remove();
                    this.pageKeys.remove(entry.getKey());
                    --numToRemove;
                }
            }
            for (SerializedPageWrapper wrapper : pagesToAdd) {
                PageKey pageKey = new PageKey(wrapper.getPageId(), wrapper.getVersionNumber(), wrapper.getAjaxVersionNumber());
                this.pages.remove(pageKey);
                this.pages.put(pageKey, wrapper);
                this.pageKeys.put(pageKey, this.id.getAndIncrement());
            }
        }
        finally {
            this.write.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsPage(int pageId, int pageVersion) {
        this.read.lock();
        try {
            PageKey below = new PageKey(pageId, pageVersion, -1);
            PageKey above = new PageKey(pageId, pageVersion + 1, -1);
            SortedMap<PageKey, Integer> thisPageAndVersion = this.pageKeys.subMap(below, above);
            boolean bl = !thisPageAndVersion.isEmpty();
            return bl;
        }
        finally {
            this.read.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SerializedPageWrapper getPage(int id, int versionNumber, int ajaxVersionNumber) {
        this.read.lock();
        try {
            SerializedPageWrapper sPage = null;
            if (versionNumber != -1 && ajaxVersionNumber != -1) {
                sPage = this.pages.get(new PageKey(id, versionNumber, ajaxVersionNumber));
            } else if (versionNumber == -1) {
                PageKey fromKey = new PageKey(id, -1, -1);
                PageKey toKey = new PageKey(id + 1, -1, -1);
                SortedMap<PageKey, Integer> subMap = this.pageKeys.subMap(fromKey, toKey);
                int max = -1;
                PageKey maxPageKey = null;
                for (Map.Entry<PageKey, Integer> entry : subMap.entrySet()) {
                    if (entry.getValue() <= max) continue;
                    max = entry.getValue();
                    maxPageKey = entry.getKey();
                }
                if (maxPageKey != null) {
                    sPage = this.pages.get(maxPageKey);
                }
            } else {
                PageKey toElement = new PageKey(id, versionNumber + 1, -1);
                SortedMap<PageKey, Integer> posiblePageKeys = this.pageKeys.headMap(toElement);
                if (posiblePageKeys.size() > 0) {
                    sPage = this.pages.get(posiblePageKeys.lastKey());
                }
            }
            SerializedPageWrapper serializedPageWrapper = sPage;
            return serializedPageWrapper;
        }
        finally {
            this.read.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePage(int id) {
        this.write.lock();
        try {
            Iterator<Map.Entry<PageKey, SerializedPageWrapper>> iter = this.pages.entrySet().iterator();
            while (iter.hasNext()) {
                PageKey pKey = iter.next().getKey();
                if (id != pKey.getPageId()) continue;
                iter.remove();
                this.pageKeys.remove(pKey);
            }
        }
        finally {
            this.write.unlock();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<PageKey, SerializedPageWrapper> entry : this.pages.entrySet()) {
            sb.append("\t").append(entry.getKey().toString()).append("\n");
        }
        if (log.isTraceEnabled()) {
            sb.append("\tPageKeys TreeSet: ").append(this.pageKeys.toString());
        }
        return sb.toString();
    }
}

