/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.ki.wicket.page.store;

import org.apache.wicket.IClusterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageKey
implements IClusterable,
Comparable<PageKey> {
    private static final long serialVersionUID = 1L;
    protected static final int PRIME = 31;
    private final int pageId;
    private final int version;
    private final int ajaxVersion;

    public PageKey(int pageId, int version, int ajaxVersion) {
        this.pageId = pageId;
        this.version = version;
        this.ajaxVersion = ajaxVersion;
    }

    public int getPageId() {
        return this.pageId;
    }

    public int getVersion() {
        return this.version;
    }

    public int getAjaxVersion() {
        return this.ajaxVersion;
    }

    protected Object clone() {
        PageKey clone;
        try {
            clone = (PageKey)super.clone();
        }
        catch (CloneNotSupportedException neverHappens) {
            throw new InternalError("Unable to clone object of type [" + this.getClass().getName() + "]");
        }
        return clone;
    }

    @Override
    public int compareTo(PageKey pk) {
        if (this.pageId != pk.pageId) {
            return this.pageId - pk.pageId;
        }
        if (this.version != pk.version) {
            return this.version - pk.version;
        }
        if (this.ajaxVersion != pk.ajaxVersion) {
            return this.ajaxVersion - pk.ajaxVersion;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof PageKey) {
            PageKey pk = (PageKey)o;
            return this.pageId == pk.pageId && this.version == pk.version && this.ajaxVersion == pk.ajaxVersion;
        }
        return false;
    }

    public int hashCode() {
        int result = 31 * this.pageId;
        result = 31 * result + this.version;
        result = 31 * result + this.ajaxVersion;
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(53);
        sb.append("pageId: ").append(this.pageId).append(", version: ").append(this.version).append(", ajaxVersion: ").append(this.ajaxVersion);
        return sb.toString();
    }
}

