/*
 * Decompiled with CFR 0.152.
 */
package wicket.contrib.phonebook.web;

import java.util.Iterator;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.filter.IFilterStateLocator;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;
import org.apache.wicket.model.IModel;
import wicket.contrib.phonebook.Contact;
import wicket.contrib.phonebook.ContactDao;
import wicket.contrib.phonebook.QueryParam;
import wicket.contrib.phonebook.web.DetachableContactModel;

public class ContactsDataProvider
extends SortableDataProvider<Contact, String>
implements IFilterStateLocator<Contact> {
    private static final long serialVersionUID = 1L;
    private final ContactDao dao;
    private Contact filter = new Contact();
    private QueryParam queryParam;

    public void setQueryParam(QueryParam queryParam) {
        this.queryParam = queryParam;
    }

    public Contact getFilterState() {
        return this.filter;
    }

    public void setFilterState(Contact state) {
        this.filter = state;
    }

    public ContactsDataProvider(ContactDao dao) {
        this.dao = dao;
        this.setSort((Object)"firstname", SortOrder.ASCENDING);
    }

    public Iterator<Contact> iterator(long first, long count) {
        SortParam sp = this.getSort();
        if (this.queryParam == null) {
            this.queryParam = new QueryParam(first, count, (String)sp.getProperty(), sp.isAscending());
        } else {
            this.queryParam.setFirst(first);
            this.queryParam.setCount(count);
            this.queryParam.setSort((String)sp.getProperty());
            this.queryParam.setSortAsc(sp.isAscending());
        }
        return this.dao.find(this.queryParam, this.filter);
    }

    public long size() {
        return this.dao.count(this.filter);
    }

    public IModel<Contact> model(Contact object) {
        return new DetachableContactModel(object, this.dao);
    }
}

