/*
 * $Id: org.eclipse.jdt.ui.prefs 367 2005-10-11 16:06:41 -0700 (Tue, 11 Oct 2005) ivaynberg $
 * $Revision: 367 $
 * $Date: 2005-10-11 16:06:41 -0700 (Tue, 11 Oct 2005) $
 *
 * ==============================================================================
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package wicket.contrib.phonebook.web;

import java.io.Serializable;
import java.util.Collection;
import java.util.Set;

import org.apache.wicket.MarkupContainer;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.table.HeaderlessColumn;
import org.apache.wicket.markup.IMarkupResourceStreamProvider;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.StringResourceStream;

/**
 * Checkbox column for {@link DataTable}
 * 
 * @see CheckBoxModel
 * @author ivaynberg
 * 
 */
public abstract class CheckBoxColumn<T> extends HeaderlessColumn<T, String>
{
	private static final long serialVersionUID = 1L;
	private final IModel<Collection<Serializable>> selectionModel;

	/**
	 * Constructor
	 * 
	 * @param selectionModel
	 *            model that represents a collection of selected tokens generated by
	 *            {@link #getModelObjectToken(IModel)}. Usually this collection is a {@link Set} of
	 *            primary keys.
	 */
	public CheckBoxColumn(IModel<Collection<Serializable>> selectionModel)
	{
		this.selectionModel = selectionModel;
	}

	public void populateItem(Item<ICellPopulator<T>> cellItem, String componentId,
		IModel<T> rowModel)
	{

		cellItem.add(new CheckBoxPanel(componentId, selectionModel, getModelObjectToken(rowModel)));
	}

	/**
	 * Generates a token from the model object that will represent the selected state of this row.
	 * The implementation should usually return a primary key of the object inside the provided
	 * model.
	 * 
	 * Example: <code>return ((User)model.getObject()).getId();</code>
	 * 
	 * @param model
	 *            model that contains an object bound to current row of the table
	 * @return a token which will uniquely identify the selection of this row
	 */
	protected abstract Serializable getModelObjectToken(IModel<T> model);

	private static class CheckBoxPanel extends Panel implements IMarkupResourceStreamProvider
	{

		private static final long serialVersionUID = 1L;

		public CheckBoxPanel(String id, IModel<Collection<Serializable>> model, Serializable token)
		{
			super(id, model);
			add(new CheckBox("checkbox", new CheckBoxModel(model, token)));
		}

		public IResourceStream getMarkupResourceStream(MarkupContainer container,
			Class<?> containerClass)
		{
			return new StringResourceStream(
				"<wicket:panel><input wicket:id=\"checkbox\" type=\"checkbox\"/></wicket:panel>");
		}
	}

}
