/*
 * Decompiled with CFR 0.152.
 */
package wicket.contrib.phonebook;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.type.AbstractSingleColumnStandardBasicType;
import org.hibernate.type.StandardBasicTypes;
import wicket.contrib.phonebook.Contact;
import wicket.contrib.phonebook.QueryParam;

public class HibernateContactFinderQueryBuilder {
    private List<String> parameters;
    private List<AbstractSingleColumnStandardBasicType<?>> types;
    private boolean count;
    private Contact filter = new Contact();
    private QueryParam queryParam;

    public String buildHql() {
        this.parameters = new ArrayList();
        this.types = new ArrayList();
        StringBuilder hql = new StringBuilder();
        this.addCountClause(hql);
        hql.append("from Contact target where 1=1 ");
        this.addMatchingCondition(hql, this.filter.getFirstname(), "firstname");
        this.addMatchingCondition(hql, this.filter.getLastname(), "lastname");
        this.addMatchingCondition(hql, this.filter.getPhone(), "phone");
        this.addMatchingCondition(hql, this.filter.getEmail(), "email");
        this.addOrderByClause(hql);
        return hql.toString();
    }

    private void addCountClause(StringBuilder hql) {
        if (this.count) {
            hql.append("select count(*) ");
        }
    }

    private void addMatchingCondition(StringBuilder hql, String value, String name) {
        if (value != null) {
            hql.append("and upper(target.");
            hql.append(name);
            hql.append(") like (?)");
            this.parameters.add("%" + value.toUpperCase() + "%");
            this.types.add(StandardBasicTypes.STRING);
        }
    }

    private void addOrderByClause(StringBuilder hql) {
        if (!this.count && this.queryParam != null && this.queryParam.hasSort()) {
            hql.append("order by upper(target.");
            hql.append(this.queryParam.getSort());
            hql.append(") ");
            hql.append(this.queryParam.isSortAsc() ? "asc" : "desc");
        }
    }

    public void setQueryParam(QueryParam queryParam) {
        this.queryParam = queryParam;
    }

    public void setFilter(Contact filter) {
        if (filter == null) {
            throw new IllegalArgumentException("Null value not allowed.");
        }
        this.filter = filter;
    }

    public void setCount(boolean count) {
        this.count = count;
    }

    public String[] getParameters() {
        return this.parameters.toArray(new String[0]);
    }

    public AbstractSingleColumnStandardBasicType<?>[] getTypes() {
        return this.types.toArray(new AbstractSingleColumnStandardBasicType[this.types.size()]);
    }
}

