/*
 * Decompiled with CFR 0.152.
 */
package wicket.contrib.phonebook;

import hendrey.orm.DatabaseSession;
import hendrey.orm.ORMDictionary;
import hendrey.orm.ORMapping;
import hendrey.orm.Query;
import hendrey.orm.Record;
import hendrey.orm.RecordSet;
import hendrey.shades.DatabaseSessionFactory;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.sql.DataSource;
import wicket.contrib.phonebook.Contact;
import wicket.contrib.phonebook.ContactDao;
import wicket.contrib.phonebook.QueryParam;
import wicket.contrib.phonebook.ShadesORMDictionary;

public class ShadesContactDao
implements ContactDao {
    private final ORMDictionary dict = ShadesORMDictionary.getInstance();
    private final ORMapping orm = this.dict.getORM("CONTACT");
    private final DatabaseSession dbSess = DatabaseSessionFactory.newSession((ORMDictionary)this.dict);
    private DataSource dataSource;

    public ShadesContactDao() {
        this.dbSess.printSQL((OutputStream)System.out);
    }

    public Contact load(long id) {
        Connection con = null;
        try {
            con = this.dataSource.getConnection();
            Query q = this.dict.getQuery("byId");
            this.dbSess.setParameter("id", (Object)id);
            Contact contact = (Contact)this.dbSess.executeQuery(con, q).populateNext((Object)new Contact());
            return contact;
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            try {
                con.close();
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public Contact save(Contact contact) {
        Connection con = null;
        try {
            con = this.dataSource.getConnection();
            System.out.println("saving Contact: " + contact);
            Record[] loadedRecords = this.dbSess.getRecords((Object)contact);
            if (0 != loadedRecords.length) {
                this.dbSess.update(con, new Object[]{contact});
                System.out.println("updated");
            } else {
                this.dbSess.insert(con, (Object)contact, new ORMapping[]{this.orm});
                System.out.println("saved");
            }
            Contact contact2 = contact;
            return contact2;
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            try {
                this.dbSess.clear();
                con.close();
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public void delete(long id) {
        Connection con = null;
        try {
            con = this.dataSource.getConnection();
            this.dbSess.delete(con, this.dbSess.getRecords((Object)this.load(id)));
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            try {
                this.dbSess.clear();
                con.close();
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public Iterator<Contact> find(QueryParam qp, Contact filter) {
        System.out.println("looking for contacts like " + filter);
        Query q = this.dict.getQuery("byOrderedResemblance");
        ShadesORMDictionary.filterCandidate.resembles((Object)filter, this.orm.getColumnSet("nonKeyFields"));
        this.dbSess.setParameter("first", (Object)qp.getFirst());
        this.dbSess.setParameter("count", (Object)qp.getCount());
        q.clause("ORDER BY").enable(qp.hasSort());
        this.dbSess.setParameter("order", (Object)qp.getSort());
        if (qp.isSortAsc()) {
            this.dbSess.setParameter("direction", (Object)"ASC");
        } else {
            this.dbSess.setParameter("direction", (Object)"DESC");
        }
        Connection con = null;
        ArrayList list = new ArrayList();
        try {
            con = this.dataSource.getConnection();
            this.dbSess.executeQuery(con, q).populateList(list, Contact.class);
            System.out.println(list);
            Iterator<Contact> iterator = list.iterator();
            return iterator;
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            try {
                this.dbSess.clear();
                con.close();
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public int count(Contact filter) {
        this.dbSess.clear();
        Query q = this.dict.getQuery("byResemblance");
        ShadesORMDictionary.filterCandidate.resembles((Object)filter, this.orm.getColumnSet("nonKeyFields"));
        Connection con = null;
        try {
            con = this.dataSource.getConnection();
            int n = this.dbSess.count(con, q);
            return n;
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            try {
                con.close();
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public List<String> getUniqueLastNames() {
        Query q = this.dict.getQuery("selectDistinctLastnameOnly");
        Connection con = null;
        try {
            con = this.dataSource.getConnection();
            RecordSet rs = this.dbSess.executeQuery(con, q);
            ArrayList<String> lastnames = new ArrayList<String>();
            Contact c = new Contact();
            while (rs.next()) {
                rs.populate((Object)c);
                lastnames.add(c.getLastname());
            }
            ArrayList<String> arrayList = lastnames;
            return arrayList;
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            try {
                this.dbSess.clear();
                con.close();
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public final void setDataSource(DataSource ds) {
        this.dataSource = ds;
    }

    public final DataSource getDataSource() {
        return this.dataSource;
    }
}

