/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.whiteboard;

import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.protocol.ws.api.WebSocketBehavior;
import org.apache.wicket.protocol.ws.api.message.ClosedMessage;
import org.apache.wicket.protocol.ws.api.message.ConnectedMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.whiteboard.WhiteboardBehavior;

public class Whiteboard
extends Panel {
    private static final Logger log = LoggerFactory.getLogger(Whiteboard.class);
    private static final long serialVersionUID = 1L;

    public Whiteboard(String whiteboardID, String markupId, String whiteboardContent, String clipArtFolderPath, String docFolderPath) {
        super(markupId);
        this.add(new Behavior[]{new WebSocketBehavior(){
            private static final long serialVersionUID = -3311970325911992958L;

            protected void onConnect(ConnectedMessage message) {
                super.onConnect(message);
                log.debug("Connecting :" + message.toString());
            }

            protected void onClose(ClosedMessage message) {
                super.onClose(message);
                log.debug("Disconnecting :" + message.toString());
            }
        }});
        this.add(new Component[]{new WebMarkupContainer("whiteboard")});
        this.add(new Behavior[]{new WhiteboardBehavior(whiteboardID, "whiteboard", whiteboardContent, clipArtFolderPath, docFolderPath)});
    }
}

