/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.whiteboard;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.json.JSONArray;
import org.apache.wicket.ajax.json.JSONException;
import org.apache.wicket.ajax.json.JSONObject;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.head.PriorityHeaderItem;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.ws.IWebSocketSettings;
import org.apache.wicket.protocol.ws.api.IWebSocketConnection;
import org.apache.wicket.protocol.ws.api.registry.IWebSocketConnectionRegistry;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.http.WebRequest;
import org.apache.wicket.request.resource.ResourceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.whiteboard.Background;
import org.wicketstuff.whiteboard.WhiteboardData;
import org.wicketstuff.whiteboard.elements.CircleGeneral;
import org.wicketstuff.whiteboard.elements.Circle_3p;
import org.wicketstuff.whiteboard.elements.ClipArt;
import org.wicketstuff.whiteboard.elements.Element;
import org.wicketstuff.whiteboard.elements.LineGeneral;
import org.wicketstuff.whiteboard.elements.Line_2p;
import org.wicketstuff.whiteboard.elements.PencilArrow;
import org.wicketstuff.whiteboard.elements.PencilCircle;
import org.wicketstuff.whiteboard.elements.PencilCurve;
import org.wicketstuff.whiteboard.elements.PencilFreeLine;
import org.wicketstuff.whiteboard.elements.PencilPointAtRect;
import org.wicketstuff.whiteboard.elements.PencilPointer;
import org.wicketstuff.whiteboard.elements.PencilRect;
import org.wicketstuff.whiteboard.elements.PencilUnderline;
import org.wicketstuff.whiteboard.elements.PointAtCircle;
import org.wicketstuff.whiteboard.elements.PointAtLine;
import org.wicketstuff.whiteboard.elements.PointFree;
import org.wicketstuff.whiteboard.elements.Point_2c;
import org.wicketstuff.whiteboard.elements.Point_2l;
import org.wicketstuff.whiteboard.elements.Point_lc;
import org.wicketstuff.whiteboard.elements.Segment;
import org.wicketstuff.whiteboard.elements.Text;
import org.wicketstuff.whiteboard.resource.GoogStyleSheetResourceReference;
import org.wicketstuff.whiteboard.resource.TranslateJavaScriptResourceReference;
import org.wicketstuff.whiteboard.resource.WhiteboardHelperJavaScriptResourceReference;
import org.wicketstuff.whiteboard.resource.WhiteboardJavaScriptResourceReference;
import org.wicketstuff.whiteboard.resource.WhiteboardStyleSheetResourceReference;
import org.wicketstuff.whiteboard.settings.IWhiteboardLibrarySettings;

public class WhiteboardBehavior
extends AbstractDefaultAjaxBehavior {
    private static final Map<String, WhiteboardData> whiteboardMap = new ConcurrentHashMap<String, WhiteboardData>();
    private static final Logger log = LoggerFactory.getLogger(WhiteboardBehavior.class);
    private static final long serialVersionUID = 1L;
    private String whiteboardMarkupId;
    private String whiteboardObjectId;
    private Map<Integer, Element> elementMap;
    private Map<Integer, Element> loadedElementMap;
    private BlockingDeque<List<Element>> undoSnapshots;
    private BlockingDeque<List<Boolean>> undoSnapshotCreationList;
    private List<Element> snapShot = null;
    private List<Boolean> snapShotCreation = null;
    private DateFormat dateFormat = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss");
    private ArrayList<String> clipArts;
    private String clipArtFolder;
    private Map<String, ArrayList<String>> docMap;
    private String documentFolder;
    private Background background;
    private BlockingDeque<Background> undoSnapshots_Background;
    private BlockingDeque<Boolean> undoSnapshotCreationList_Background;
    private BlockingDeque<Boolean> isElementSnapshotList;
    private String loadedContent = "";

    public WhiteboardBehavior(String whiteboardObjectId, String whiteboardMarkupId) {
        this(whiteboardObjectId, whiteboardMarkupId, null, null, null);
    }

    public WhiteboardBehavior(String whiteboardObjectId, String whiteboardMarkupId, String whiteboardContent, String clipArtFolder, String documentFolder) {
        WhiteboardData whiteboardData;
        this.whiteboardObjectId = whiteboardObjectId;
        this.whiteboardMarkupId = whiteboardMarkupId;
        if (!whiteboardMap.containsKey(whiteboardObjectId)) {
            this.elementMap = new ConcurrentHashMap<Integer, Element>();
            this.loadedElementMap = new ConcurrentHashMap<Integer, Element>();
            this.undoSnapshots = new LinkedBlockingDeque<List<Element>>(20);
            this.undoSnapshotCreationList = new LinkedBlockingDeque<List<Boolean>>(20);
            this.undoSnapshots_Background = new LinkedBlockingDeque<Background>(20);
            this.undoSnapshotCreationList_Background = new LinkedBlockingDeque<Boolean>(20);
            this.isElementSnapshotList = new LinkedBlockingDeque<Boolean>(20);
            this.clipArts = new ArrayList();
            this.docMap = new ConcurrentHashMap<String, ArrayList<String>>();
            this.loadedContent = whiteboardContent;
            whiteboardData = new WhiteboardData(this.elementMap, this.loadedElementMap, this.undoSnapshots, this.undoSnapshotCreationList, this.undoSnapshots_Background, this.undoSnapshotCreationList_Background, this.isElementSnapshotList, this.clipArts, null, this.docMap, null, null, whiteboardContent);
            whiteboardMap.put(whiteboardObjectId, whiteboardData);
        } else {
            whiteboardData = whiteboardMap.get(whiteboardObjectId);
            this.elementMap = whiteboardData.getElementMap();
            this.loadedElementMap = whiteboardData.getLoadedElementMap();
            this.undoSnapshots = whiteboardData.getUndoSnapshots();
            this.undoSnapshotCreationList = whiteboardData.getUndoSnapshotCreationList();
            this.clipArts = whiteboardData.getClipArts();
            this.docMap = whiteboardData.getDocMap();
            this.clipArtFolder = whiteboardData.getClipArtFolder();
            this.documentFolder = whiteboardData.getDocumentFolder();
            this.background = whiteboardData.getBackground();
            this.loadedContent = whiteboardData.getLoadedContent();
            this.undoSnapshots_Background = whiteboardData.getUndoSnapshots_Background();
            this.undoSnapshotCreationList_Background = whiteboardData.getUndoSnapshotCreationList_Background();
            this.isElementSnapshotList = whiteboardData.getIsElementSnapshotList();
        }
        if (!"".equals(this.loadedContent)) {
            whiteboardMap.get(whiteboardObjectId).setLoadedContent(this.loadedContent);
            if (whiteboardContent != null && !whiteboardContent.equals("")) {
                try {
                    JSONObject savedContent = new JSONObject(whiteboardContent);
                    JSONArray elementList = (JSONArray)savedContent.get("elements");
                    this.snapShot = new ArrayList<Element>();
                    this.snapShotCreation = new ArrayList<Boolean>();
                    for (int i = 0; i < elementList.length(); ++i) {
                        JSONObject jElement = (JSONObject)elementList.get(i);
                        Element element = this.getElementObject(jElement);
                        if (element == null) continue;
                        this.elementMap.put(element.getId(), element);
                        this.loadedElementMap.put(element.getId(), element);
                        this.snapShot.add(element);
                        this.snapShotCreation.add(true);
                    }
                    if (this.undoSnapshots.isEmpty()) {
                        this.undoSnapshots.addLast(this.snapShot);
                        this.undoSnapshotCreationList.addLast(this.snapShotCreation);
                        this.isElementSnapshotList.addLast(true);
                    }
                    this.snapShot = null;
                    this.snapShotCreation = null;
                    if (savedContent.has("background")) {
                        JSONObject backgroundJSON = (JSONObject)savedContent.get("background");
                        this.background = new Background(backgroundJSON);
                        whiteboardMap.get(whiteboardObjectId).setBackground(this.background);
                        this.undoSnapshots_Background.addLast(new Background("Background", "", 0.0, 0.0, 0.0, 0.0));
                        this.undoSnapshotCreationList_Background.addLast(true);
                        this.isElementSnapshotList.addLast(false);
                    }
                }
                catch (JSONException e) {
                    log.error("Unexpected error while constructing WhiteboardBehavior", (Throwable)e);
                }
            }
        }
        if (clipArtFolder != null && !clipArtFolder.equals("")) {
            this.clipArtFolder = clipArtFolder;
            whiteboardMap.get(whiteboardObjectId).setClipArtFolder(clipArtFolder);
            this.loadClipArts();
        }
        if (documentFolder != null && !documentFolder.equals("")) {
            this.documentFolder = documentFolder;
            whiteboardMap.get(whiteboardObjectId).setDocumentFolder(documentFolder);
            this.loadDocuments();
        }
    }

    protected void respond(AjaxRequestTarget target) {
        RequestCycle cycle = RequestCycle.get();
        WebRequest webRequest = (WebRequest)cycle.getRequest();
        if (webRequest.getQueryParameters().getParameterNames().contains("editedElement")) {
            String editedElement = webRequest.getQueryParameters().getParameterValue("editedElement").toString();
            this.handleEditedElement(editedElement);
        } else if (webRequest.getQueryParameters().getParameterNames().contains("undo")) {
            this.handleUndo();
        } else if (webRequest.getQueryParameters().getParameterNames().contains("eraseAll")) {
            this.handleEraseAll();
        } else if (webRequest.getQueryParameters().getParameterNames().contains("save")) {
            this.handleSave();
        } else if (webRequest.getQueryParameters().getParameterNames().contains("clipArt")) {
            this.handleClipArts();
        } else if (webRequest.getQueryParameters().getParameterNames().contains("docList")) {
            this.handleDocs();
        } else if (webRequest.getQueryParameters().getParameterNames().contains("docComponents")) {
            String docBaseName = webRequest.getQueryParameters().getParameterValue("docBaseName").toString();
            this.handleDocComponents(docBaseName);
        } else if (webRequest.getQueryParameters().getParameterNames().contains("background")) {
            String backgroundString = webRequest.getQueryParameters().getParameterValue("background").toString();
            this.handleBackground(backgroundString);
        }
    }

    private boolean handleEditedElement(String editedElement) {
        try {
            JSONObject jsonEditedElement = new JSONObject(editedElement);
            Element element = this.getElementObject(jsonEditedElement);
            boolean isLoaded = false;
            if (!this.elementMap.isEmpty() && this.loadedElementMap.get(element.getId()) != null && !this.loadedElementMap.isEmpty()) {
                isLoaded = this.isEqual(element.getJSON(), this.loadedElementMap.get(element.getId()).getJSON());
            }
            if (!isLoaded) {
                if (this.snapShot == null && this.snapShotCreation == null) {
                    this.snapShot = new ArrayList<Element>();
                    this.snapShotCreation = new ArrayList<Boolean>();
                }
                if (this.elementMap.containsKey(element.getId()) && !this.elementMap.isEmpty()) {
                    this.snapShot.add(this.elementMap.get(element.getId()));
                    this.snapShotCreation.add(false);
                } else {
                    this.snapShot.add(element);
                    this.snapShotCreation.add(true);
                }
                if (Element.Type.PointFree != element.getType()) {
                    if (this.undoSnapshots.size() == 20) {
                        this.undoSnapshots.pollFirst();
                        this.undoSnapshotCreationList.pollFirst();
                    }
                    if (Element.Type.PencilCurve == element.getType()) {
                        List lastElementSnapshot = (List)this.undoSnapshots.peekLast();
                        if (lastElementSnapshot != null) {
                            Element lastSnapshotElement = (Element)lastElementSnapshot.get(lastElementSnapshot.size() - 1);
                            if (lastSnapshotElement instanceof PencilCurve && lastSnapshotElement.getId() == element.getId()) {
                                List lastCreationSnapshot = (List)this.undoSnapshotCreationList.getLast();
                                for (int i = 0; i < this.snapShot.size(); ++i) {
                                    lastElementSnapshot.add(this.snapShot.get(i));
                                    lastCreationSnapshot.add(this.snapShotCreation.get(i));
                                }
                            } else {
                                this.undoSnapshots.addLast(this.snapShot);
                                this.undoSnapshotCreationList.addLast(this.snapShotCreation);
                                this.isElementSnapshotList.addLast(true);
                            }
                        }
                    } else if (Element.Type.ClipArt == element.getType()) {
                        List snapShotTemp = (List)this.undoSnapshots.pollLast();
                        List snapShotCreationTemp = (List)this.undoSnapshotCreationList.pollLast();
                        for (int i = 0; i < snapShotTemp.size(); ++i) {
                            this.snapShot.add((Element)snapShotTemp.get(i));
                            this.snapShotCreation.add((Boolean)snapShotCreationTemp.get(i));
                        }
                        this.undoSnapshots.addLast(this.snapShot);
                        this.undoSnapshotCreationList.addLast(this.snapShotCreation);
                        this.isElementSnapshotList.addLast(true);
                    } else {
                        this.undoSnapshots.addLast(this.snapShot);
                        this.undoSnapshotCreationList.addLast(this.snapShotCreation);
                        this.isElementSnapshotList.addLast(true);
                    }
                    this.snapShot = null;
                    this.snapShotCreation = null;
                }
                if (element != null) {
                    this.elementMap.put(element.getId(), element);
                    IWebSocketConnectionRegistry reg = IWebSocketSettings.Holder.get((Application)Application.get()).getConnectionRegistry();
                    for (IWebSocketConnection c : reg.getConnections(Application.get())) {
                        try {
                            JSONObject jsonObject = new JSONObject(editedElement);
                            c.sendMessage(this.getAddElementMessage(jsonObject).toString());
                        }
                        catch (Exception e) {
                            log.error("Unexpected error while sending message through the web socket", (Throwable)e);
                        }
                    }
                }
            }
            return true;
        }
        catch (JSONException e) {
            log.error("Unexpected error while editing element", (Throwable)e);
            return false;
        }
    }

    private boolean handleBackground(String backgroundString) {
        try {
            Background backgroundObject;
            JSONObject backgroundJSON = new JSONObject(backgroundString);
            this.background = backgroundObject = new Background(backgroundJSON);
            Background previousBackground = new Background("Background", "", 0.0, 0.0, 0.0, 0.0);
            if (whiteboardMap.get(this.whiteboardObjectId).getBackground() != null) {
                previousBackground = whiteboardMap.get(this.whiteboardObjectId).getBackground();
            }
            whiteboardMap.get(this.whiteboardObjectId).setBackground(this.background);
            this.undoSnapshotCreationList_Background.addLast(previousBackground == null);
            this.undoSnapshots_Background.addLast(previousBackground);
            this.isElementSnapshotList.addLast(false);
            IWebSocketConnectionRegistry reg = IWebSocketSettings.Holder.get((Application)Application.get()).getConnectionRegistry();
            for (IWebSocketConnection c : reg.getConnections(Application.get())) {
                try {
                    JSONObject jsonObject = new JSONObject(backgroundString);
                    c.sendMessage(this.getAddBackgroundMessage(jsonObject).toString());
                }
                catch (Exception e) {
                    log.error("Unexpected error while sending message through the web socket", (Throwable)e);
                }
            }
            return true;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean handleUndo() {
        if (!this.isElementSnapshotList.isEmpty()) {
            if (((Boolean)this.isElementSnapshotList.pollLast()).booleanValue()) {
                List undoCreationList = (List)this.undoSnapshotCreationList.pollLast();
                List undoElement = (List)this.undoSnapshots.pollLast();
                String deleteList = "";
                JSONArray changeList = new JSONArray();
                IWebSocketConnectionRegistry reg = IWebSocketSettings.Holder.get((Application)Application.get()).getConnectionRegistry();
                for (int i = 0; i < undoElement.size(); ++i) {
                    if (((Boolean)undoCreationList.get(i)).booleanValue()) {
                        this.elementMap.remove(((Element)undoElement.get(i)).getId());
                        if (this.loadedElementMap.containsKey(((Element)undoElement.get(i)).getId())) {
                            this.loadedContent = "";
                            whiteboardMap.get(this.whiteboardObjectId).setLoadedContent("");
                            this.loadedElementMap.remove(((Element)undoElement.get(i)).getId());
                        }
                        if ("".equals(deleteList)) {
                            deleteList = "" + ((Element)undoElement.get(i)).getId();
                            continue;
                        }
                        deleteList = deleteList + "," + ((Element)undoElement.get(i)).getId();
                        continue;
                    }
                    this.elementMap.put(((Element)undoElement.get(i)).getId(), (Element)undoElement.get(i));
                    try {
                        changeList.put((Object)((Element)undoElement.get(i)).getJSON());
                        continue;
                    }
                    catch (JSONException e) {
                        log.error("Unexpected error while getting JSON", (Throwable)e);
                    }
                }
                for (IWebSocketConnection c : reg.getConnections(Application.get())) {
                    try {
                        c.sendMessage(this.getUndoMessage(changeList, deleteList).toString());
                    }
                    catch (Exception e) {
                        log.error("Unexpected error while sending message through the web socket", (Throwable)e);
                    }
                }
            } else {
                Background previousBackground;
                this.background = previousBackground = (Background)this.undoSnapshots_Background.pollLast();
                whiteboardMap.get(this.whiteboardObjectId).setBackground(previousBackground);
                IWebSocketConnectionRegistry reg = IWebSocketSettings.Holder.get((Application)Application.get()).getConnectionRegistry();
                for (IWebSocketConnection c : reg.getConnections(Application.get())) {
                    try {
                        if (previousBackground != null) {
                            c.sendMessage(this.getAddBackgroundMessage(previousBackground.getJSON()).toString());
                            continue;
                        }
                        c.sendMessage(this.getAddBackgroundMessage(new JSONObject()).toString());
                    }
                    catch (Exception e) {
                        log.error("Unexpected error while sending message through the web socket", (Throwable)e);
                    }
                }
            }
            return true;
        }
        return false;
    }

    private boolean handleEraseAll() {
        this.elementMap.clear();
        IWebSocketConnectionRegistry reg = IWebSocketSettings.Holder.get((Application)Application.get()).getConnectionRegistry();
        for (IWebSocketConnection c : reg.getConnections(Application.get())) {
            try {
                JSONArray jsonArray = new JSONArray();
                c.sendMessage(this.getEraseAllMessage(jsonArray).toString());
                return true;
            }
            catch (Exception e) {
                log.error("Unexpected error while sending message through the web socket", (Throwable)e);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleSave() {
        ServletContext servletContext = WebApplication.get().getServletContext();
        String saveFolderPath = servletContext.getRealPath("") + "/Saved_Whiteboards";
        File saveFolder = new File(saveFolderPath);
        if (!saveFolder.exists()) {
            saveFolder.mkdir();
        }
        boolean result = false;
        JSONObject saveObject = new JSONObject();
        JSONArray elementArray = new JSONArray();
        for (int elementID : this.elementMap.keySet()) {
            try {
                elementArray.put((Object)this.elementMap.get(elementID).getJSON());
            }
            catch (JSONException e) {
                log.error("Unexpected error while getting JSON", (Throwable)e);
            }
        }
        JSONObject backgroundJSON = null;
        if (this.background != null) {
            try {
                backgroundJSON = this.background.getJSON();
            }
            catch (JSONException e) {
                log.error("Unexpected error while getting JSON", (Throwable)e);
            }
        }
        try {
            saveObject.put("elements", (Object)elementArray);
            if (backgroundJSON != null) {
                saveObject.put("background", (Object)backgroundJSON);
            }
        }
        catch (JSONException e) {
            log.error("Unexpected error while getting JSON", (Throwable)e);
        }
        File whiteboardFile = new File(saveFolderPath + "/Whiteboard_" + this.dateFormat.format(new Date()) + ".json");
        OutputStreamWriter writer = null;
        try {
            whiteboardFile.createNewFile();
            log.debug("Going to dump WB to file: " + whiteboardFile.getAbsolutePath());
            writer = new FileWriter(whiteboardFile);
            writer.write(saveObject.toString());
            writer.flush();
            result = true;
        }
        catch (IOException e) {
            log.debug("Unexpected error during dumping WB to file ", (Throwable)e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                    log.debug("Dumped WB to file: " + whiteboardFile.getAbsolutePath());
                }
                catch (IOException e) {
                    log.debug("Unexpected error during closing WB file ", (Throwable)e);
                    result = false;
                }
            }
        }
        return result;
    }

    private void handleClipArts() {
        this.loadClipArts();
        IWebSocketConnectionRegistry reg = IWebSocketSettings.Holder.get((Application)Application.get()).getConnectionRegistry();
        for (IWebSocketConnection c : reg.getConnections(Application.get())) {
            try {
                JSONArray jsonArray = new JSONArray();
                for (String clipArtURL : this.clipArts) {
                    jsonArray.put((Object)clipArtURL);
                }
                c.sendMessage(this.getClipArtListMessage(jsonArray).toString());
            }
            catch (Exception e) {
                log.error("Unexpected error while sending message through the web socket", (Throwable)e);
            }
        }
    }

    private void handleDocs() {
        this.loadDocuments();
        IWebSocketConnectionRegistry reg = IWebSocketSettings.Holder.get((Application)Application.get()).getConnectionRegistry();
        for (IWebSocketConnection c : reg.getConnections(Application.get())) {
            try {
                JSONArray jsonArray = new JSONArray();
                Set<String> keySet = this.docMap.keySet();
                for (String key : keySet) {
                    jsonArray.put((Object)this.docMap.get(key).get(0));
                }
                c.sendMessage(this.getDocumentListMessage(jsonArray).toString());
            }
            catch (Exception e) {
                log.error("Unexpected error while sending message through the web socket", (Throwable)e);
            }
        }
    }

    private void handleDocComponents(String docBaseName) {
        this.loadDocuments();
        IWebSocketConnectionRegistry reg = IWebSocketSettings.Holder.get((Application)Application.get()).getConnectionRegistry();
        for (IWebSocketConnection c : reg.getConnections(Application.get())) {
            try {
                JSONArray jsonArray = new JSONArray();
                for (String url : this.docMap.get(docBaseName)) {
                    jsonArray.put((Object)url);
                }
                c.sendMessage(this.getDocumentComponentListMessage(jsonArray).toString());
            }
            catch (Exception e) {
                log.error("Unexpected error while sending message through the web socket", (Throwable)e);
            }
        }
    }

    private JSONObject getAddElementMessage(JSONObject element) throws JSONException {
        return new JSONObject().put("type", (Object)"addElement").put("json", (Object)element);
    }

    private JSONObject getAddBackgroundMessage(JSONObject element) throws JSONException {
        return new JSONObject().put("type", (Object)"addBackground").put("json", (Object)element);
    }

    private JSONObject getUndoMessage(JSONArray changeList, String deleteList) throws JSONException {
        return new JSONObject().put("type", (Object)"undoList").put("changeList", (Object)changeList).put("deleteList", (Object)deleteList);
    }

    private JSONObject getEraseAllMessage(JSONArray array) throws JSONException {
        return new JSONObject().put("type", (Object)"eraseElements").put("json", (Object)array);
    }

    private JSONObject getClipArtListMessage(JSONArray array) throws JSONException {
        return new JSONObject().put("type", (Object)"clipArtList").put("json", (Object)array);
    }

    private JSONObject getDocumentListMessage(JSONArray array) throws JSONException {
        return new JSONObject().put("type", (Object)"documentList").put("json", (Object)array);
    }

    private JSONObject getDocumentComponentListMessage(JSONArray array) throws JSONException {
        return new JSONObject().put("type", (Object)"documentComponentList").put("json", (Object)array);
    }

    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        this.initReferences(response);
        try {
            JSONArray elements = null;
            if (!this.elementMap.isEmpty()) {
                TreeMap<Integer, Element> sortedElementList = new TreeMap<Integer, Element>(this.elementMap);
                elements = new JSONArray();
                for (Element e : sortedElementList.values()) {
                    elements.put((Object)e.getJSON());
                }
            }
            response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)String.format("initWB('%s', '%s', %s, %s);", this.getCallbackUrl(), this.whiteboardMarkupId, elements, this.background == null ? null : this.background.getJSON())));
        }
        catch (JSONException e) {
            log.error("Unexpected error while getting JSON", (Throwable)e);
        }
    }

    private void initReferences(IHeaderResponse response) {
        IWhiteboardLibrarySettings settings = WhiteboardBehavior.getLibrarySettings();
        if (settings != null && settings.getWhiteboardStyleSheetReference() != null) {
            response.render((HeaderItem)new PriorityHeaderItem((HeaderItem)CssHeaderItem.forReference((ResourceReference)settings.getWhiteboardStyleSheetReference())));
        } else {
            response.render((HeaderItem)new PriorityHeaderItem((HeaderItem)CssHeaderItem.forReference((ResourceReference)WhiteboardStyleSheetResourceReference.get())));
        }
        if (settings != null && settings.getGoogStyleSheetReference() != null) {
            response.render((HeaderItem)new PriorityHeaderItem((HeaderItem)CssHeaderItem.forReference((ResourceReference)settings.getGoogStyleSheetReference())));
        } else {
            response.render((HeaderItem)new PriorityHeaderItem((HeaderItem)CssHeaderItem.forReference((ResourceReference)GoogStyleSheetResourceReference.get())));
        }
        if (settings != null && settings.getTranslateJavaScriptReference() != null) {
            response.render((HeaderItem)new PriorityHeaderItem((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)settings.getTranslateJavaScriptReference())));
        } else {
            response.render((HeaderItem)new PriorityHeaderItem((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)TranslateJavaScriptResourceReference.get())));
        }
        if (settings != null && settings.getWhiteboardJavaScriptReference() != null) {
            response.render((HeaderItem)new PriorityHeaderItem((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)settings.getWhiteboardJavaScriptReference())));
        } else {
            response.render((HeaderItem)new PriorityHeaderItem((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)WhiteboardJavaScriptResourceReference.get())));
        }
        if (settings != null && settings.getWhiteboardHelperJavaScriptReference() != null) {
            response.render((HeaderItem)new PriorityHeaderItem((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)settings.getWhiteboardHelperJavaScriptReference())));
        } else {
            response.render((HeaderItem)new PriorityHeaderItem((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)WhiteboardHelperJavaScriptResourceReference.get())));
        }
    }

    private static IWhiteboardLibrarySettings getLibrarySettings() {
        if (Application.exists() && Application.get().getJavaScriptLibrarySettings() instanceof IWhiteboardLibrarySettings) {
            return (IWhiteboardLibrarySettings)Application.get().getJavaScriptLibrarySettings();
        }
        return null;
    }

    public Map<Integer, Element> getElementMap() {
        return this.elementMap;
    }

    private Element getElementObject(JSONObject obj) throws JSONException {
        Element element = null;
        Element.Type type = Element.Type.valueOf(obj.getString("type"));
        switch (type) {
            case CircleGeneral: {
                element = new CircleGeneral(obj);
                break;
            }
            case Circle_3p: {
                element = new Circle_3p(obj);
                break;
            }
            case LineGeneral: {
                element = new LineGeneral(obj);
                break;
            }
            case Line_2p: {
                element = new Line_2p(obj);
                break;
            }
            case PencilArrow: {
                element = new PencilArrow(obj);
                break;
            }
            case PencilCircle: {
                element = new PencilCircle(obj);
                break;
            }
            case PencilCurve: {
                element = new PencilCurve(obj);
                break;
            }
            case PencilFreeLine: {
                element = new PencilFreeLine(obj);
                break;
            }
            case PencilPointAtRect: {
                element = new PencilPointAtRect(obj);
                break;
            }
            case PencilPointer: {
                element = new PencilPointer(obj);
                break;
            }
            case PencilRect: {
                element = new PencilRect(obj);
                break;
            }
            case PencilUnderline: {
                element = new PencilUnderline(obj);
                break;
            }
            case PointAtCircle: {
                element = new PointAtCircle(obj);
                break;
            }
            case PointAtLine: {
                element = new PointAtLine(obj);
                break;
            }
            case PointFree: {
                element = new PointFree(obj);
                break;
            }
            case Point_2c: {
                element = new Point_2c(obj);
                break;
            }
            case Point_2l: {
                element = new Point_2l(obj);
                break;
            }
            case Point_lc: {
                element = new Point_lc(obj);
                break;
            }
            case Segment: {
                element = new Segment(obj);
                break;
            }
            case Text: {
                element = new Text(obj);
                break;
            }
            case ClipArt: {
                element = new ClipArt(obj);
                break;
            }
        }
        return element;
    }

    private void loadClipArts() {
        List<String> pictureExtensions = Arrays.asList("jpg", "bmp", "png", "jpeg", "gif");
        ServletContext servletContext = WebApplication.get().getServletContext();
        HttpServletRequest httpReq = (HttpServletRequest)((WebRequest)RequestCycle.get().getRequest()).getContainerRequest();
        Url relative = Url.parse((CharSequence)httpReq.getContextPath());
        String basURL = RequestCycle.get().getUrlRenderer().renderFullUrl(relative);
        String clipArtFolderPath = servletContext.getRealPath("") + "/" + this.clipArtFolder;
        File folder = new File(clipArtFolderPath);
        for (File fileEntry : folder.listFiles()) {
            String clipArtURL;
            if (fileEntry.isDirectory()) continue;
            String extension = "";
            int i = fileEntry.getAbsolutePath().lastIndexOf(46);
            if (i > 0) {
                extension = fileEntry.getAbsolutePath().substring(i + 1);
            }
            if (!pictureExtensions.contains(extension) || this.clipArts.contains(clipArtURL = basURL + "/" + this.clipArtFolder + "/" + fileEntry.getName())) continue;
            this.clipArts.add(clipArtURL);
        }
    }

    private void loadDocuments() {
        String pictureExtension = "jpg";
        ServletContext servletContext = WebApplication.get().getServletContext();
        HttpServletRequest httpReq = (HttpServletRequest)((WebRequest)RequestCycle.get().getRequest()).getContainerRequest();
        Url relative = Url.parse((CharSequence)httpReq.getContextPath());
        String basURL = RequestCycle.get().getUrlRenderer().renderFullUrl(relative);
        String clipArtFolderPath = servletContext.getRealPath("") + "/" + this.documentFolder;
        File folder = new File(clipArtFolderPath);
        for (File fileEntry : folder.listFiles()) {
            if (fileEntry.isDirectory()) continue;
            String extension = "";
            int i = fileEntry.getAbsolutePath().lastIndexOf(46);
            if (i > 0) {
                extension = fileEntry.getAbsolutePath().substring(i + 1);
            }
            if (!pictureExtension.equals(extension)) continue;
            String docURL = basURL + "/" + this.documentFolder + "/" + fileEntry.getName();
            String documentName = fileEntry.getName().substring(0, fileEntry.getName().lastIndexOf(46));
            if (-1 == documentName.lastIndexOf(95)) {
                ArrayList<String> docList = new ArrayList<String>();
                docList.add(docURL);
                this.docMap.put(documentName, docList);
                continue;
            }
            String documentBaseName = documentName.substring(0, documentName.lastIndexOf(95));
            if (!this.docMap.containsKey(documentBaseName)) continue;
            this.docMap.get(documentBaseName).add(docURL);
        }
    }

    private boolean isEqual(JSONObject element1, JSONObject element2) {
        for (String key : JSONObject.getNames((JSONObject)element1)) {
            Object value = null;
            try {
                Number y;
                Number x;
                value = element2.get(key);
                if (value == null) {
                    return false;
                }
                if (value instanceof String) {
                    if (value.equals(element1.get(key))) continue;
                    return false;
                }
                if (value instanceof Integer) {
                    x = (Integer)value;
                    y = (Integer)element1.get(key);
                    if (((Integer)x).intValue() == ((Integer)y).intValue()) continue;
                    return false;
                }
                if (!(value instanceof Double)) continue;
                x = (Double)value;
                y = (Double)element1.get(key);
                if (((Double)x).doubleValue() == ((Double)y).doubleValue()) continue;
                return false;
            }
            catch (JSONException e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }
}

