/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.whiteboard.elements;

import java.io.Serializable;
import org.apache.wicket.ajax.json.JSONException;
import org.apache.wicket.ajax.json.JSONObject;

public abstract class Element
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected int id;
    protected String label;
    protected String color;
    protected Boolean trace;
    protected Boolean hidden;
    protected Type type;

    public Element(int id, String label, String color, Boolean hidden, Type type, Boolean trace) {
        this.id = id;
        this.label = label;
        this.color = color;
        this.hidden = hidden;
        this.type = type;
        this.trace = trace;
    }

    public Element(JSONObject object) throws JSONException {
        this.id = object.optInt("id");
        this.label = object.optString("label");
        this.color = object.optString("color");
        this.trace = object.optBoolean("trace");
        this.hidden = object.optBoolean("hidden");
    }

    public abstract JSONObject getJSON() throws JSONException;

    public JSONObject getJSON(JSONObject obj) throws JSONException {
        obj.put("id", this.id);
        obj.put("type", (Object)this.type);
        if (this.label != null) {
            obj.put("label", (Object)this.label);
        }
        if (this.color != null) {
            obj.put("color", (Object)this.color);
        }
        if (this.hidden != null) {
            obj.put("hidden", (Object)this.hidden);
        }
        if (this.trace != null) {
            obj.put("trace", (Object)this.trace);
        }
        return obj;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public Boolean isTrace() {
        return this.trace;
    }

    public void setTrace(Boolean trace) {
        this.trace = trace;
    }

    public Boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public static enum Type {
        Circle_3p,
        CircleGeneral,
        Line_2p,
        LineGeneral,
        PencilArrow,
        PencilCircle,
        PencilCurve,
        PencilFreeLine,
        PencilPointAtRect,
        PencilPointer,
        PencilRect,
        PencilUnderline,
        Point_2c,
        Point_2l,
        PointAtCircle,
        PointAtLine,
        PointFree,
        Point_lc,
        Segment,
        Text,
        ClipArt;

    }
}

