/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.whiteboard.elements;

import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.ajax.json.JSONException;
import org.apache.wicket.ajax.json.JSONObject;
import org.wicketstuff.whiteboard.elements.Element;

public class PencilCurve
extends Element {
    private static final long serialVersionUID = 1L;
    protected int p0;
    protected List<Double[][]> points;

    public PencilCurve(int id, String label, String color, Boolean hidden, Element.Type type, Boolean trace, int p0, List<Double[][]> points) {
        super(id, label, color, hidden, type, trace);
        this.p0 = p0;
        this.points = points;
    }

    public PencilCurve(JSONObject object) throws JSONException {
        super(object);
        this.type = Element.Type.PencilCurve;
        this.p0 = object.getInt("p0");
        int pointCount = 0;
        try {
            while (true) {
                object.get("x" + pointCount);
                ++pointCount;
            }
        }
        catch (JSONException e) {
            this.points = new ArrayList<Double[][]>();
            for (int i = 0; i < pointCount; ++i) {
                if (object.get("x" + i) instanceof Double) {
                    Double[][] point = new Double[][]{{object.getDouble("x" + i), object.getDouble("y" + i)}};
                    this.points.add(point);
                    continue;
                }
                double x = object.getInt("x" + i);
                double y = object.getInt("y" + i);
                Double[][] point = new Double[][]{{x, y}};
                this.points.add(point);
            }
            return;
        }
    }

    @Override
    public JSONObject getJSON() throws JSONException {
        JSONObject jsonObject = super.getJSON(new JSONObject());
        jsonObject.put("p0", this.p0);
        for (int i = 0; i < this.points.size(); ++i) {
            jsonObject.put("x" + i, (Object)this.points.get(i)[0][0]);
            jsonObject.put("y" + i, (Object)this.points.get(i)[0][1]);
        }
        return jsonObject;
    }

    public List<Double[][]> getPoints() {
        return this.points;
    }

    public void setPoints(List<Double[][]> points) {
        this.points = points;
    }

    public int getP0() {
        return this.p0;
    }

    public void setP0(int p0) {
        this.p0 = p0;
    }
}

