/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.wiquery.core.javascript;

import org.wicketstuff.wiquery.core.events.EventLabel;

public final class JsUtils {
    public static CharSequence array(CharSequence ... args) {
        StringBuilder array = new StringBuilder();
        array.append('[');
        if (args.length > 0) {
            array.append(args[0]);
            for (int i = 1; i < args.length; ++i) {
                array.append(", ").append(args[i]);
            }
        }
        array.append(']');
        return array.toString();
    }

    public static String doubleQuotes(CharSequence stringToDoubleQuote) {
        return JsUtils.doubleQuotes(stringToDoubleQuote, false);
    }

    public static String doubleQuotes(CharSequence stringToDoubleQuote, boolean escapeDoubleQuote) {
        return "\"" + (escapeDoubleQuote ? JsUtils.escapeDoubleQuote(stringToDoubleQuote) : stringToDoubleQuote) + "\"";
    }

    public static String escapeDoubleQuote(CharSequence stringToDoubleQuote) {
        return stringToDoubleQuote == null ? null : stringToDoubleQuote.toString().replace("\"", "\\\"");
    }

    public static String escapeQuote(CharSequence stringToQuote) {
        return stringToQuote == null ? null : stringToQuote.toString().replace("'", "\\'");
    }

    public static String implode(EventLabel ... eventLabels) {
        if (eventLabels.length == 0) {
            return "''";
        }
        StringBuilder output = new StringBuilder();
        output.append('\'').append(eventLabels[0].getEventLabel());
        for (int i = 1; i < eventLabels.length; ++i) {
            EventLabel eventLabel = eventLabels[i];
            output.append(' ').append(eventLabel.getEventLabel());
        }
        output.append('\'');
        return output.toString();
    }

    public static String quotes(CharSequence stringToQuote) {
        return JsUtils.quotes(stringToQuote, false);
    }

    public static String quotes(CharSequence stringToQuote, boolean escapeQuote) {
        return "'" + (escapeQuote ? JsUtils.escapeQuote(stringToQuote) : stringToQuote) + "'";
    }

    public static String string(int value) {
        return String.valueOf(value);
    }

    private JsUtils() {
    }
}

