/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.wiquery.core;

import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.wiquery.core.javascript.JsQuery;
import org.wicketstuff.wiquery.core.javascript.JsScope;
import org.wicketstuff.wiquery.core.javascript.JsScopeContext;
import org.wicketstuff.wiquery.core.javascript.JsStatement;
import org.wicketstuff.wiquery.tester.WiQueryTestCase;

public class JSQueryTestCase
extends WiQueryTestCase {
    protected static final Logger log = LoggerFactory.getLogger(JSQueryTestCase.class);

    @Test
    public void testJSQuerySyntax() {
        JsQuery jsq = new JsQuery();
        JsStatement jst = jsq.$(".sample").chain((CharSequence)"css", new CharSequence[]{"'foo'", "'bar'"});
        String expected = "$('.sample').css('foo', 'bar');";
        String generated = jst.render().toString();
        log.info(expected);
        log.info(generated);
        Assert.assertEquals((Object)generated, (Object)expected);
        jsq = new JsQuery();
        expected = "$('.sample').ready(function() {\n\talert('foo');\n\talert('bar');\n});";
        jst = jsq.$(".sample").ready(new JsScope(new String[0]){
            private static final long serialVersionUID = 1L;

            protected void execute(JsScopeContext scopeContext) {
                scopeContext.append((CharSequence)"alert('foo')");
                scopeContext.append((CharSequence)"alert('bar')");
            }
        });
        generated = jst.render().toString();
        log.info(expected);
        log.info(generated);
        Assert.assertEquals((Object)generated, (Object)expected);
        expected = "$('.sample').each(function() {\n\t$(this).css('foo');\n\t$(this).css('bar');\n});";
        jsq = new JsQuery();
        jst = jsq.$(".sample").each(new JsScope(new String[0]){
            private static final long serialVersionUID = 1L;

            protected void execute(JsScopeContext scopeContext) {
                scopeContext.self().chain((CharSequence)"css", new CharSequence[]{"'foo'"});
                scopeContext.self().chain((CharSequence)"css", new CharSequence[]{"'bar'"});
            }
        });
        generated = jst.render().toString();
        log.info(expected);
        log.info(generated);
        Assert.assertEquals((Object)generated, (Object)expected);
        jsq = new JsQuery();
        jsq.$(".foo").chain((CharSequence)"css", new CharSequence[]{"bar"});
        JsStatement jss = new JsStatement();
        jss.append(jsq.getStatement().render());
        log.info(jss.render().toString());
    }

    @Override
    protected Logger getLog() {
        return log;
    }
}

