/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.wiquery.core.effects;

import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.wiquery.core.effects.Animate;
import org.wicketstuff.wiquery.core.effects.AnimateDuration;
import org.wicketstuff.wiquery.core.javascript.ChainableStatement;
import org.wicketstuff.wiquery.core.javascript.JsStatement;
import org.wicketstuff.wiquery.tester.WiQueryTestCase;

public class AnimateTestCase
extends WiQueryTestCase {
    protected static final Logger log = LoggerFactory.getLogger(AnimateTestCase.class);

    @Test
    public void testStatementArgs() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("width", "100%");
        AnimateDuration duration = new AnimateDuration(Integer.valueOf(500));
        String expectedJavascript = "$('#aComponent').animate({width: '100%'}, {duration: 500});";
        String generatedJavascript = new JsStatement().$(null, "#aComponent").chain((ChainableStatement)new Animate(properties, duration)).render().toString();
        log.info(expectedJavascript);
        log.info(generatedJavascript);
        Assert.assertEquals((Object)generatedJavascript, (Object)expectedJavascript);
        expectedJavascript = "$('#aComponent').animate({width: '100%'}, {duration: 500, easing: 'linear'});";
        generatedJavascript = new JsStatement().$(null, "#aComponent").chain((ChainableStatement)new Animate(properties, duration, "linear")).render().toString();
        log.info(expectedJavascript);
        log.info(generatedJavascript);
        Assert.assertEquals((Object)generatedJavascript, (Object)expectedJavascript);
    }

    @Override
    protected Logger getLog() {
        return log;
    }
}

