/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.wiquery.core.javascript.helper;

import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.wiquery.core.javascript.JsScope;
import org.wicketstuff.wiquery.core.javascript.JsStatement;
import org.wicketstuff.wiquery.core.javascript.helper.AttributesHelper;
import org.wicketstuff.wiquery.tester.WiQueryTestCase;

public class AttributesHelperTestCase
extends WiQueryTestCase {
    protected static final Logger log = LoggerFactory.getLogger(AttributesHelperTestCase.class);

    @Test
    public void testAddClass() {
        String expectedJavascript = "$('div').addClass('myClass');";
        String generatedJavascript = new JsStatement().$(null, "div").chain(AttributesHelper.addClass((String)"myClass")).render().toString();
        log.info(expectedJavascript);
        log.info(generatedJavascript);
        Assert.assertEquals((Object)generatedJavascript, (Object)expectedJavascript);
    }

    @Test
    public void testAttr() {
        String expectedJavascript = "$('div').attr('title', 'a title');";
        String generatedJavascript = new JsStatement().$(null, "div").chain(AttributesHelper.attr((String)"title", (String)"a title")).render().toString();
        log.info(expectedJavascript);
        log.info(generatedJavascript);
        Assert.assertEquals((Object)generatedJavascript, (Object)expectedJavascript);
    }

    @Test
    public void testAttrScope() {
        String expectedJavascript = "$('div').attr('click', function() {\n\talert('click done');\n});";
        String generatedJavascript = new JsStatement().$(null, "div").chain(AttributesHelper.attr((String)"click", (JsScope)JsScope.quickScope((CharSequence)"alert('click done');"))).render().toString();
        log.info(expectedJavascript);
        log.info(generatedJavascript);
        Assert.assertEquals((Object)generatedJavascript, (Object)expectedJavascript);
    }

    @Test
    public void testHtml() {
        String expectedJavascript = "$('div').html('some text');";
        String generatedJavascript = new JsStatement().$(null, "div").chain(AttributesHelper.html((CharSequence)"some text")).render().toString();
        log.info(expectedJavascript);
        log.info(generatedJavascript);
        Assert.assertEquals((Object)generatedJavascript, (Object)expectedJavascript);
    }

    @Test
    public void testRemoveAttr() {
        String expectedJavascript = "$('div').removeAttr('title');";
        String generatedJavascript = new JsStatement().$(null, "div").chain(AttributesHelper.removeAttr((String)"title")).render().toString();
        log.info(expectedJavascript);
        log.info(generatedJavascript);
        Assert.assertEquals((Object)generatedJavascript, (Object)expectedJavascript);
    }

    @Test
    public void testRemoveClass() {
        String expectedJavascript = "$('div').removeClass('myClass');";
        String generatedJavascript = new JsStatement().$(null, "div").chain(AttributesHelper.removeClass((String)"myClass")).render().toString();
        log.info(expectedJavascript);
        log.info(generatedJavascript);
        Assert.assertEquals((Object)generatedJavascript, (Object)expectedJavascript);
    }

    @Test
    public void testToggleClass() {
        String expectedJavascript = "$('div').toggleClass('myClass');";
        String generatedJavascript = new JsStatement().$(null, "div").chain(AttributesHelper.toggleClass((String)"myClass")).render().toString();
        log.info(expectedJavascript);
        log.info(generatedJavascript);
        Assert.assertEquals((Object)generatedJavascript, (Object)expectedJavascript);
    }

    @Override
    protected Logger getLog() {
        return log;
    }
}

